\name{lrSS}
\alias{lrSS}
\title{Sample size required to show difference in survival by log-rank test given prior information about Kaplan-Meier estimate}
\source{
  Schoenfeld D 1983 Sample-size formula for the
  proportional-hazards regression model.
  \emph{Biometrics};\bold{39}:499--503.
  \href{http://www.jstor.org/stable/2531021}{JSTOR}
}
\usage{
  lrSS(HR, PRIOR = FALSE, Sp, tp, mtp, a, f, alpha = 0.1,
    beta = 0.2, p = 0.5)
}
\arguments{
  \item{HR}{Hazard Ratio. Ratio of hazard with treatment to
  that without.}

  \item{PRIOR}{if \code{TRUE} then additional estimates
  will be given}

  \item{Sp}{Prior Kaplan-Meier estimate of survival (given
  no intervention)}

  \item{tp}{Prior times corresponding to survival
  estimates. \cr Must be one for each of: \eqn{f, 0.5*a+f,
  a+f}.}

  \item{mtp}{Prior median time (of survival)}

  \item{a}{Accrue. Time period for which subjects accrued}

  \item{f}{Follow-up. Time period for which subjects
  followed-up}

  \item{alpha}{Significance level \eqn{\alpha}{alpha},
  two-tailed}

  \item{beta}{Power is \eqn{1-\beta}{1-beta}}

  \item{p}{Proportion of subjects allocated to one group.
  Arbitrary - can be either of the two groups.}
}
\value{
  If \code{PRIOR = FALSE}, \bold{n}, the no. of subjects
  required (with no prior information). \cr \cr If
  \code{PRIOR = TRUE}, A list with the following values:
  \describe{ \item{n}{no. of subjects required (with no
  prior information)} \item{pS}{with prior Kaplan-Meier
  estimates: \describe{ \item{dB}{probability death in
  group B (that with prior information)}
  \item{dA}{probability death in group A (new treatment)}
  \item{p}{overall probability of death} \item{n}{no. of
  subjects required} }} \item{pM}{with prior median
  survival time estimates: \describe{ \item{dB}{probability
  death in group B (that with prior information)}
  \item{dA}{probability death in group A (new treatment)}
  \item{p}{overall probability of death} \item{n}{no.
  subjects required} }} }
}
\description{
  No. of events required in a two-group trial (with one
  binary covariate) for a two-sided log-rank test to detect
  a given hazard ratio. \cr This is calculated by: \deqn{
  n= \frac{ ({Z_{\frac{\alpha}{2}}+Z_{\beta}) }^2}{ p(1-p)
  \log^2{HR} }}{ n = ( Z(alpha/2)+Z(beta) )^2 /
  (log(HR^2)p(1-p))} Where \eqn{Z} refers to the
  corresponding Z-value from the standard normal
  distribution. \cr \cr This default calculation requires
  that the subjects be followed until \emph{all} have
  experienced the event of interest (typically death). If
  this is not likely to be the case, then a more informed
  estimate may be generated by dividing \eqn{n} by the
  overall probability of death occurring by the end of the
  study. \cr This may be generated with prior information
  about \eqn{\hat{S}}{S} and median survival times (for
  group \eqn{B} of groups \eqn{A} and \eqn{B}). \cr \cr
  Given accrual time \eqn{a} and follow-up time \eqn{f},
  Simpsons rule can be used to give an estimate of the
  proportion of patients that will die in group \eqn{B}:
  \deqn{ d_B = 1-\frac{1}{6}[\hat{S}_B(f) +
  4\hat{S}_B(f+0.5a) + \hat{S}_B(f+a)] }{ dB = 1 - 1/6(
  S(f) +4S(f+0.5a) +S(f+a) )} Given median survival time
  \eqn{t}, the proportion of patients expected to die in
  group \eqn{B} is: \deqn{ d_B = [1 - \frac{ \exp{
  \frac{-0.69f}{t}} (1 - \exp{
  \frac{-0.69f}{t}})}{\frac{0.69a}{t}}] }{ dB = 1 - (
  exp(-0.69f/t) [1-exp(-0.69f/t)] / 0.69a/t )}
}
\note{
  Assumes there are two groups and one intervention
  (covariate) which is present or absent. The values for
  the example are taken from Schoenfelds paper, except for
  \code{mtp}.
}
\examples{
data(btumors)
lrSS(HR=1.5)
m1 <- mean(rep(btumors[,"ms"],btumors[,"n"]))
lrSS(HR=1.5,PRIOR=TRUE,
Sp=c(0.43,0.2,0.11),tp=c(1,2,3),
mtp=m1,a=2,f=1,alpha=0.1,beta=0.2,p=0.5)
}

