% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{normalise2d}
\alias{normalise2d}
\title{normalise2d}
\usage{
normalise2d(mat, pnorm = 2L, axis = 0L)
}
\arguments{
\item{mat}{numeric matrix}

\item{pnorm}{integer value, default value=2}

\item{axis}{integer (0 or 1), row wise = 0,  column wise = 1}
}
\value{
normalised numeric matrix
}
\description{
Normalises a matrix towards unit p norm row wise or column wise. By default, p = 2 is used.
To normalise row wise, use axis=0. To normalise column wise, use axis=1.
as the square root of sum of square of values in the given vector.
}
\examples{
mat <- matrix(runif(12), 3, 4)

## normalise matrix row wise
r <- normalise2d(mat, axis=0)

## normalise matrix column wise
r <- normalise2d(mat, axis=1)

}
