% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsStatistical.R
\name{precisionMeasureWithCustomDF}
\alias{precisionMeasureWithCustomDF}
\alias{CIwithDF.mean}
\title{Confidence intervals with custom degree of freedom}
\usage{
CIwithDF.mean(x, gamma = 0.95 )
}
\arguments{
\item{x}{a vector of numbers, the sample data (mandatory);}

\item{gamma}{a vector containing first a confidence level for CI (default 0.95) and
a custom degree of freedom (default n-1 where n is the number of observations in x).}
}
\value{
the confidence interval (CI) where the t value is based on the custom-set degree of freedom.
}
\description{
The following three functions can be used with missing data.
They return the mean, the standard error of the mean and the confidence interval of the mean.
Note that we hesitated to provide these functions: you should deal with missing data prior
to making your plot.
}
\examples{
# this will issue a warning as no custom degree of freedom is provided
CIwithDF.mean( c(1,2,3), gamma = 0.90)          
# the confidence interval of the mean for 90\% confidence level
CIwithDF.mean( c(1,2,3), gamma = c(0.90, 1.5) ) # uses 1.5 as df instead of 2.

}
\references{
\insertAllCited{}
}
