% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styling.R
\name{get_group_rows}
\alias{get_group_rows}
\title{Get row numbers of variable group headers for gt styling}
\usage{
get_group_rows(tbl)
}
\arguments{
\item{tbl}{A gtsummary table object with variable group headers created by
\code{gtsummary::add_variable_group_header()}}
}
\value{
An integer vector of row numbers where variable_group headers are located
}
\description{
Extracts the row indices of variable group headers from a
gtsummary table. This is useful for applying background colors or other
gt-specific styling after converting a gtsummary table to gt with \code{as_gt()}.
}
\details{
Variable group headers are identified by \code{row_type == 'variable_group'}
in the table body. The returned row numbers can be used with \code{gt::tab_style()}
to apply styling like background colors after converting to a gt table.

This function should be called BEFORE converting the table with \code{as_gt()},
as the row type information is only available in gtsummary table objects.
}
\examples{
\donttest{
# Create table with variable groups
my_tbl <- gtsummary::trial |>
  gtsummary::tbl_summary(by = trt, include = c(age, marker, grade, stage)) |>
  gtsummary::add_variable_group_header(
    header = "Demographics",
    variables = age
  ) |>
  gtsummary::add_variable_group_header(
    header = "Clinical",
    variables = marker:stage
  ) |>
  add_group_styling()

# Get group row numbers before conversion
group_rows <- get_group_rows(my_tbl)

# Convert to gt and apply gray background
my_tbl |>
  gtsummary::as_gt() |>
  gt::tab_style(
    style = gt::cell_fill(color = "#E8E8E8"),
    locations = gt::cells_body(rows = group_rows)
  )
}

}
\seealso{
\itemize{
\item \code{add_group_styling()} for applying text formatting to group headers
\item \code{gtsummary::add_variable_group_header()} for creating variable groups
\item \code{gt::tab_style()} for applying gt-specific styling
}
}
