% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr_generic.R
\name{plot.cgrcusum}
\alias{plot.cgrcusum}
\alias{plot.bkcusum}
\alias{plot.funnelplot}
\alias{plot.bercusum}
\title{Plot a quality control chart}
\usage{
\method{plot}{cgrcusum}(x, h, ...)

\method{plot}{bkcusum}(x, h, ...)

\method{plot}{funnelplot}(x, percentage = TRUE, unit_label = TRUE,
  label_size = 3, col_fill = "blue", ...)

\method{plot}{bercusum}(x, h = x$h, ...)
}
\arguments{
\item{x}{Chart to plot}

\item{h}{Control limit to display for \code{cgrcusum}, \code{bkcusum} or \code{bercusum}}

\item{...}{Further plotting parameters}

\item{percentage}{Should output be shown in percentages? Default is \code{TRUE}.}

\item{unit_label}{Should unit labels be displayed next to detected units in the funnel plot?
Default is \code{TRUE}.}

\item{label_size}{Size of the labels when \code{unit_label} is \code{TRUE}. Default is 3.}

\item{col_fill}{Single fill colour for the prediction intervals in the funnel plot.
In any format that \code{\link[grDevices]{col2rgb}} accepts. Default is \code{"blue"}.}
}
\value{
A plot of the associated chart is displayed in the current graphics device.
}
\description{
Plot a \code{cgrcusum}, \code{bkcusum},
\code{bercusum} or \code{funnelplot} chart, or a list containing a combination of
\code{'bercusum'}, \code{'bkcusum'} and \code{'cgrcusum'} charts.
}
\section{Methods (by class)}{
\itemize{
\item \code{plot(cgrcusum)}: Plot a CGR-CUSUM

\item \code{plot(bkcusum)}: Plot a BK-CUSUM

\item \code{plot(funnelplot)}: Display a funnel plot

\item \code{plot(bercusum)}: Plot a Bernoulli CUSUM

}}
\seealso{
\code{\link[success]{cgr_cusum}}, \code{\link[success]{bk_cusum}}, \code{\link[success]{bernoulli_cusum}}, \code{\link[success]{funnel_plot}}
}
\author{
Daniel Gomon
}
