#' Spatial data
#'
#' The \code{drome} data are the spatial example used as an ecological application of the WitOMI calculations in
#' Karasiewicz et al. (2017).
#' @usage data(drome)
#' @format The \code{drome} is a list of 3 components.
#'
#'  \code{env}
#'    is a dataframe with 64 rows with 6 environmental tables, collected in 10 different rivers.
#'
#'
#'  \code{fish}
#'    is a dataframe with 64 rows and 13 columns (12 fish species, including young and older trouts).
#'
#'
#'  \code{code}
#'    is a dataframe with 13 rows and 2 columns, the species, common and scientific, name and their respective code.
#'
#'
#' @source Doledec S., Chessel D. and Gimaret C. (2000). Niche separation in community analysis: a new method. \emph{Ecology},\bold{81}(10), 2914-1927.
#'
#' @references Karasiewicz S.,Doledec S.and Lefebvre S. (2017). Within outlying mean indexes: refining the OMI analysis for the realized niche decomposition. \emph{PeerJ} 5:e3364. \url{https://doi.org/10.7717/peerj.3364}.
#'
#'
#'
"drome"


#' Temporal data
#'
#' The \code{ardecheinv} data are the temporal example used as an ecological application of the WitOMI calculations in
#' Karasiewicz et al. (2017).
#' @usage data(ardecheinv)
#' @format The \code{ardecheinv} is a list of 3 components.
#'
#'  \code{env}
#'    is a dataframe of 67 rows with 5 environmental tables, collected in spring and autumn.
#'
#'
#'  \code{Invertebrates}
#'    is a dataframe of 67 rows and 57 species of invertebrates.
#'
#'
#'  \code{code}
#'    is a dataframe with 57 rows and 2 columns, the species scientific name and their respective code.
#'
#' @source Merigoux, S. and Doledec, S. (2004). Hydraulic requirements of stream communities: A case study on invertebrates. \emph{Freshwater Biology}, \bold{49}(5), 600-613.
#'
#' @references Karasiewicz S.,Doledec S.and Lefebvre S. (2017). Within outlying mean indexes: refining the OMI analysis for the realized niche decomposition. \emph{PeerJ} 5:e3364. \url{https://doi.org/10.7717/peerj.3364}.
#'
"ardecheinv"

