% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules-line-breaks.R
\name{set_line_break_after_opening_if_call_is_multi_line}
\alias{set_line_break_after_opening_if_call_is_multi_line}
\title{Sets line break after opening parenthesis}
\usage{
set_line_break_after_opening_if_call_is_multi_line(
  pd,
  except_token_after = NULL,
  except_text_before = NULL,
  force_text_before = NULL
)
}
\description{
Sets line break after opening parenthesis
}
\details{
In general, every call that is multi-line has a line break after the opening
parenthesis. Exceptions:
\itemize{
\item The token right after the parenthesis is a comment, then, the line should
be broken after the comment only. Governed by \code{except_token_after}.
\item The name of the function called is \code{ifelse()} or similar, where we can
allow the condition on the same line as the function name, and we don't
impose rules on the line breaks for the subsequent arguments. Governed
by \code{except_text_before}.
\item Some calls like \code{switch()} statements are always forced to become multi-
line. Governed by \code{force_text_before}.
}
}
\keyword{internal}
