% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{find_pos_id_to_keep}
\alias{find_pos_id_to_keep}
\title{Find the pos ids to keep}
\usage{
find_pos_id_to_keep(pd)
}
\arguments{
\item{pd}{A temporary top level nest where the first expression is always a
top level expression, potentially cached.}
}
\description{
To make a parse table shallow, we must know which ids to keep.
\code{split(cumsum(pd_parent_first$parent == 0))} above puts comments with negative
parents in the same block as proceeding expressions (but also with positive).
\code{find_pos_id_to_keep()} must hence always keep negative comments. We did not
use \code{split(cumsum(pd_parent_first$parent < 1))} because then every top-level
comment is an expression on its own and processing takes much longer for
typical roxygen annotated code.
}
\details{
Note that top-level comments \strong{above} code have negative parents
(the negative value of the parent of the code expression that follows after,
another comment might be in the way though), all comments that are not top
level have positive ids. All comments for which no code follows afterwards
have parent 0.
}
\examples{
styler:::get_parse_data(c("#", "1"))
styler:::get_parse_data(c("c(#", "1)"))
styler:::get_parse_data(c("", "c(#", "1)", "#"))
}
\keyword{internal}
