% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_guides.R
\name{reindention}
\alias{reindention}
\alias{specify_reindention}
\alias{tidyverse_reindention}
\title{Specify what is re-indented how}
\usage{
specify_reindention(regex_pattern = NULL, indention = 0,
  comments_only = TRUE)

tidyverse_reindention()
}
\arguments{
\item{regex_pattern}{Character vector with regular expression patterns that
are to be re-indented with spaces, \code{NULL} if no reindention needed.}

\item{indention}{The indention tokens should have if they match
\code{regex_pattern}.}

\item{comments_only}{Whether the \code{regex_reindention_pattern} should only be
matched against comments or against all tokens. Mainly added for
performance.}
}
\description{
This function returns a list that can be used as an input for the argument
\code{reindention} of the function \code{\link[=tidyverse_style]{tidyverse_style()}}. It features sensible
defaults, so the user can specify deviations from them conveniently without
the need of setting all arguments explicitly.
}
\section{Functions}{
\itemize{
\item \code{specify_reindention}: Allows to specify which tokens are reindented and
how.

\item \code{tidyverse_reindention}: Simple forwarder to
\code{specify_reindention} with reindention according to the tidyverse style
guide.
}}

\examples{
style_text("a <- xyz", reindention = specify_reindention(
  regex_pattern = "xyz", indention = 4, comments_only = FALSE)
)
style_text("a <- xyz", reindention = tidyverse_reindention())
}
