\name{createStrumData}
\alias{createStrumData}
\title{
 Create strumData Object
}
\description{
A function to create strumData object.
}
\usage{
createStrumData(inData, dType, ibdFileName=NULL, fileType="SAGE")
}
\arguments{
  \item{inData}{Object of class \code{data.frame} containing input data.}
  \item{dType}{Character stating the type of input data, \code{"Pedigree"} or \code{"RawData"}}
  \item{ibdFileName}{Character stating the name of ibd file to import.}
  \item{fileType}{Character stating the type of ibd file, the deafult value is "SAGE".}
}
\details{
This function is used to create a strumData class object for strum analysis.  
The value of \code{inData} has to be a data.frame.  The allowed values for 
\code{dType} is either "Pedigree" or "RawData".  
Note that, if dType="Pedigree", the data must be a data.frame with 4 required 
fields - family, id, father, mother.

The ibd information for the family data can be imported by specifying the name 
of ibd file into \code{ibdFileName}.  Currently, the ibd file generated by the 
program GENIBD in S.A.G.E. package is supported.
}
\value{
Returns an object of class \code{strumData}.
}
\seealso{
\code{\linkS4class{strumData}}, \code{\link{simulateStrumData}}
}
\examples{
\dontrun{
# Create a strumData object with different type of input data.
# - dF is a data.frame containing input data.
#-------------------------------------------------------------
rawStrumData = createStrumData(dF, "RawData") 
pedStrumData = createStrumData(dF, "Pedigree")
pedStrumDataIBD = createStrumData(dF, "Pedigree", ibdFileName="ch20.ibd")
}
}

