% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{stri_opts_brkiter}
\alias{stri_opts_brkiter}
\title{Generate a List with BreakIterator Settings}
\usage{
stri_opts_brkiter(type, locale, skip_word_none, skip_word_number,
  skip_word_letter, skip_word_kana, skip_word_ideo, skip_line_soft,
  skip_line_hard, skip_sentence_term, skip_sentence_sep, ...)
}
\arguments{
\item{type}{single string; break iterator type, one of \code{character},
\code{line_break}, \code{sentence}, or \code{word};
see \link{stringi-search-boundaries}}

\item{locale}{single string, \code{NULL} or \code{""} for default locale}

\item{skip_word_none}{logical; perform no action for "words" that
do not fit into any other categories}

\item{skip_word_number}{logical; perform no action for words that
appear to be numbers}

\item{skip_word_letter}{logical; perform no action for words that
contain letters, excluding hiragana, katakana, or ideographic characters}

\item{skip_word_kana}{logical; perform no action for words
containing kana characters}

\item{skip_word_ideo}{logical; perform no action for words
containing ideographic characters}

\item{skip_line_soft}{logical; perform no action for soft line breaks,
i.e. positions at which a line break is acceptable but not required}

\item{skip_line_hard}{logical; perform no action for hard,
or mandatory line breaks}

\item{skip_sentence_term}{logical; perform no action for sentences
ending with a sentence terminator ("\code{.}", "\code{,}", "\code{?}",
"\code{!}"), possibly followed by a hard separator
(\code{CR}, \code{LF}, \code{PS}, etc.)}

\item{skip_sentence_sep}{logical; perform no action for sentences
that do not contain an ending sentence terminator, but are ended
by a hard separator or end of input}

\item{...}{any other arguments to this function are purposely ignored}
}
\value{
Returns a named list object.
Omitted \code{skip_*} values act as they have been set to \code{FALSE}.
}
\description{
A convenience function to tune the \pkg{ICU} \code{BreakIterator}'s behavior
in some text boundary analysis functions, see
\link{stringi-search-boundaries}.
}
\details{
The \code{skip_*} family of settings may be used to prevent performing
any special actions on particular types of text boundaries, e.g.
in case of the \code{\link{stri_locate_all_boundaries}} and
\code{\link{stri_split_boundaries}} functions.
}
\references{
\emph{\code{ubrk.h} File Reference} -- ICU4C API Documentation,
\url{http://icu-project.org/apiref/icu4c/ubrk_8h.html}

\emph{Boundary Analysis} -- ICU User Guide,
\url{http://userguide.icu-project.org/boundaryanalysis}
}
\seealso{
Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_split_lines}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_wrap}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search}}
}
