% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stringdist.R
\docType{package}
\name{stringdist-package}
\alias{stringdist-package}
\title{A package for string distance calculation and approximate string matching.}
\description{
A package for string distance calculation and approximate string matching.
}
\section{Introduction}{


The \pkg{stringdist} package offers fast and platform-independent string metrics.
Its main purpose is to compute various string distances and to do
approximate text matching between character vectors. A typical use is to
match strings that are not precisely the same. For example

\code{  amatch(c("hello","g'day"),c("hi","hallo","ola"),maxDist=2)}

returns \code{c(2,NA)} since \code{"hello"} matches closest with \code{"hallo"}, and within
the maximum (optimal string alignment) distance. The second element, \code{"g'day"},
matches closest with \code{"ola"} but since the distance equals 4, no match is reported.

A second typical use is to compute string distances. For example

\code{  stringdist(c("g'day"),c("hi","hallo","ola"))}

Returns \code{c(5,5,4)} since these are the distances between \code{"g'day"} and
respectively \code{"hi"}, \code{"hallo"}, and \code{"ola"}.

A third typical use would be to compute a \code{dist} object, that can be
used to cluster text strings.

\code{stringdistmatrix(c("foo","bar","boo","baz"))}

Returns an object of class \code{dist} that can be used by clustering algorithms in
the \code{cluster} package (such as \code{hclust}).

Besides documentation for each function, the main topics documented are:

\itemize{
\item{\code{\link{stringdist-metrics}} -- string metrics supported by the package}
\item{\code{\link{stringdist-encoding}} -- how encoding is handled by the package}
\item{\code{\link{stringdist-parallelization}} -- on multithreading }
}
}

\section{Acknowledgements}{

\itemize{
  \item{The code for the full Damerau-Levenshtein distance was adapted from Nick Logan's
  \href{https://github.com/ugexe/Text--Levenshtein--Damerau--XS/blob/master/damerau-int.c}{public github repository}.}
  \item{C code for converting UTF-8 to integer was copied from the R core for performance reasons.}
  \item{The code for soundex conversion was kindly contributed by Jan van der Laan.}
}
}

\section{Citation}{

If you would like to cite this package, please cite the \href{http://journal.r-project.org/archive/2014-1/loo.pdf}{R Journal Paper}:
\itemize{
\item{M.P.J. van der Loo (2014). The \code{stringdist} package for approximate string matching.
 R Journal 6(1) pp 111-122}
}
Or use \code{citation('stringdist')} to get a bibtex item.
}

