% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StreetscapeDataFrame.R
\docType{class}
\name{Streetscape-class}
\alias{Streetscape-class}
\alias{StreetscapeDataFrame}
\title{Streetscape-Class}
\description{
The output of strview_search family
functions is constructed in this data format -
A specialized data frame for streetscape package for
initializing the object with streetscape data and
extracting and decoding segmentation information
of streetscape dataframe.
}
\section{Fields}{

\describe{
\item{\code{data}}{A data frame containing metadata of Mapillary
street view images}

\item{\code{epsg}}{A numeric epsg code}
}}

\section{Methods}{

\describe{
\item{\code{decodeDetection()}}{Regenerate a dataframe with decoded segmentation.
'detections' column will be updated and
a new column 'segmentation' will be added.}

\item{\code{download_data(path, items)}}{Download street view images (and segmentations in sf format if applicable)}

\item{\code{get_mask(index)}}{Convert the semantic segmentation of a street view image
from the StreetscapeDataFrame into sf polygons}

\item{\code{gvi()}}{Calculate green view index (GVI) for each collected image by
segmenting green pixels and quantifing the percentage in
street view images. This method adds a new column of
greeness percetage to the dataframe}

\item{\code{mapPreview(maptype = "meta", fields = c())}}{Plot data points in an ineractive map view}
}}

\section{Class Methods}{

\subsection{Method list}{
\itemize{
\item \href{#method-decodeDetection}{\code{StreetscapeDataFrame$decodeDetection()}}
\item \href{#method-gvi}{\code{StreetscapeDataFrame$gvi()}}
\item \href{#method-get_mask}{\code{StreetscapeDataFrame$get_mask()}}
\item \href{#method-mapPreview}{\code{StreetscapeDataFrame$mapPreview()}}
\item \href{#method-download_data}{\code{StreetscapeDataFrame$download_data()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decodeDetection"></a>}}
\subsection{Method \code{decodeDetection()}}{
\subsection{Usage}{
\code{scdataframe$decodeDetection()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvi"></a>}}
\subsection{Method \code{gvi()}}{
\subsection{Usage}{
\code{scdataframe$gvi()}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_mask"></a>}}
\subsection{Method \code{get_mask()}}{
\subsection{Usage}{
\code{scdataframe$get_mask(index = 1)}
}
\subsection{Arguments}{
\describe{
\item{\code{index}}{numeric, the row index of the dataframe
of StreetscapeDataFrame class}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mapPreview"></a>}}
\subsection{Method \code{mapPreview()}}{
\subsection{Usage}{
\code{scdataframe$mapPreview(maptype = 'meta')}
}
\subsection{Arguments}{
\describe{
\item{\code{maptype}}{character or character,
specifying what type of information to be mapped:
'meta' - image meta,
'seg' - segmentation proportion,
and 'gvi' - GVI".}
\item{\code{fields}}{vector (optional), a vector of fields
indicates the information of images to be included
for the 'meta' map. The fields of 'id', 'is_pano',
'height', 'width', 'lon', and 'lat' are already included}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-download_data"></a>}}
\subsection{Method \code{download_data()}}{
\subsection{Usage}{
\code{scdataframe$download_data(path = 'path/to/download',
 items = c('image', 'mask'))}
}
\subsection{Arguments}{
\describe{
\item{\code{path}}{character, directory for downloading street view images
or segmentation masks or both}
\item{\code{items}}{character or vector, specifying what to download:
'image' - 'original street view image;
'mask' - semantic segmentation (sf objects in .geojson format)"}
}
}
}
}

