% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs.r
\name{run.streambugs}
\alias{run.streambugs}
\title{Run the streambugs ODE model}
\usage{
run.streambugs(y.names, times, par, inp = NA, C = FALSE, file.def = NA,
  file.res = NA, file.add = NA, return.res.add = FALSE, tout.add = NA,
  verbose = T, method = "lsoda", rtol = 1e-04, atol = 1e-04, ...)
}
\arguments{
\item{y.names}{state variables names, either as a vector encoded in the form
\code{"Reach_Habitat_Taxon"} or \code{"Reach_Habitat_Taxon_Group"}, or
a list as returned by \code{\link{decode.statevarnames}} function}

\item{times}{vector with time points for which output is wanted; the first}

\item{par}{vector with constant parameters and model inputs}

\item{inp}{list with time-dependent parameters or model inputs with one list
element for each parameter or input that includes a matrix where first
column is the time and second the corresponding parameter or input value}

\item{C}{identifier for C- or R-Version}

\item{file.def}{file name for writing system definition}

\item{file.res}{file name for results}

\item{file.add}{file name for additional output (e.g. process rates)}

\item{return.res.add}{returns \code{res.add} output additionally to res}

\item{tout.add}{optional identifier for specific output times for the
 additional output, if \code{NA} all \code{res.add} is calculated for all
times}

\item{verbose}{prints some outputs to console}

\item{method}{method used by \code{\link[deSolve]{ode}}}

\item{rtol}{argument of \code{\link[deSolve]{ode}} function defining relative
error tolerance, either a scalar or an array of the same size as \code{y.names}}

\item{atol}{argument of \code{\link[deSolve]{ode}} function defining absolute
error, either a scalar or an array of the same size as \code{y.names}}

\item{...}{further arguments passed to \code{\link[deSolve]{ode}}}
}
\value{
A list with:\describe{
   \item{\code{$res}}{matrix of class \code{\link[deSolve]{deSolve}} with up
     to as many rows aselements in times and as many columns as elements in
     \code{y.names}, plus an additional column for the time value.
     There will be a row for each element in times unless the
     FORTRAN routine \code{"lsoda"} returns with an unrecoverable error.}
   \item{\code{$res.add}}{optional additional output matrix with process
     rates and taxon specific factors, present only if \code{return.res.add}
     input parameter is set to \code{TRUE}.}
   }
}
\description{
Numerically solve streambugs ODE model (in either R or C version) for given
parameters, inputs and time points, using the \code{\link[deSolve]{ode}}
routine.
}
\section{Model syntax}{

See "doc/Streambugs_syntax.pdf" file in the package installation folder.
}

\examples{
m <- streambugs.example.model.toy()
# Display inputs: list of perturbed variables with time points and new values
m$inp
# Simluate
res.C.default <- run.streambugs(y.names = m$y.names, times = m$times,
   par = m$par, inp = m$inp, C = TRUE)
# Modify input (halve second perturbation size) and re-simulate
m$inp$Reach3_w[2,2] <- m$inp$Reach3_w[2,2] / 2
m$inp
res.C.modified <- run.streambugs(y.names = m$y.names, times = m$times,
   par = m$par, inp = m$inp, C = TRUE)
# Compare examplary trajectory of organic matter in one of the habitats
var.name <- "Reach3_Hab1_POM1_POM"
plot(m$times,res.C.default$res[, var.name], type="l", col="red")
lines(m$times, res.C.modified$res[, var.name], col="green")

}
