/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.util.ArrayList;
import java.util.Collection;
import moa.AbstractMOAObject;
import moa.MOAObject;

public class AutoExpandVector<T>
extends ArrayList<T>
implements MOAObject {
    private static final long serialVersionUID = 1L;

    public AutoExpandVector() {
        super(0);
    }

    public AutoExpandVector(int size) {
        super(size);
    }

    @Override
    public void add(int pos, T obj) {
        if (pos > this.size()) {
            while (pos > this.size()) {
                this.add((T)null);
            }
            this.trimToSize();
        }
        super.add(pos, obj);
    }

    @Override
    public T get(int pos) {
        return pos >= 0 && pos < this.size() ? (T)super.get(pos) : null;
    }

    @Override
    public T set(int pos, T obj) {
        if (pos >= this.size()) {
            this.add(pos, obj);
            return null;
        }
        return super.set(pos, obj);
    }

    @Override
    public boolean add(T arg0) {
        boolean result = super.add(arg0);
        this.trimToSize();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        boolean result = super.addAll(arg0);
        this.trimToSize();
        return result;
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        boolean result = super.addAll(arg0, arg1);
        this.trimToSize();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.trimToSize();
    }

    @Override
    public T remove(int arg0) {
        Object result = super.remove(arg0);
        this.trimToSize();
        return (T)result;
    }

    @Override
    public boolean remove(Object arg0) {
        boolean result = super.remove(arg0);
        this.trimToSize();
        return result;
    }

    @Override
    protected void removeRange(int arg0, int arg1) {
        super.removeRange(arg0, arg1);
        this.trimToSize();
    }

    @Override
    public MOAObject copy() {
        return AbstractMOAObject.copy(this);
    }

    @Override
    public int measureByteSize() {
        return AbstractMOAObject.measureByteSize(this);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

