% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hunt.R
\name{hunt}
\alias{hunt}
\title{Streamflow depletion in partially penetrating stream with semipervious streambed.}
\usage{
hunt(t, d, S, Tr, lmda, lmda_max = Inf, prec = 80)
}
\arguments{
\item{t}{times you want output for [T]}

\item{d}{distance from well to stream [L]}

\item{S}{aquifer storage coefficient (specific yield if unconfined; storativity if confined)}

\item{Tr}{aquifer transmissivity [L2/T]}

\item{lmda}{streambed conductance term, lambda [L/T]. Can be estimated with \code{streambed_conductance}.}

\item{lmda_max}{maximum allowed `lmda` [L/T]. If `lmda` is too high, exp and erfc calculations in Hunt solution are not computationally possible, so you may need to artifically reduce `lmda` using this term.}

\item{prec}{precision for \code{Rmpfr} package for storing huge numbers; 80 seems to generally work but tweak this if you get weird results. Reducing this value will reduce accuracy but speed up computation time.}
}
\value{
A numeric of \code{Qf}, streamflow depletion as fraction of pumping rate [-].
If the pumping rate of the well (\code{Qw}; [L3/T]) is known, you can calculate volumetric streamflow depletion [L3/T] as \code{Qf*Qw}
}
\description{
Streamflow depletion in partially penetrating stream with semipervious streambed.
}
\details{
This function is described in Hunt (1999). When \code{lmda} term gets very large, this is equivalent to \link{glover}. It contains numerous assumptions:
\itemize{
  \item Horizontal flow >> vertical flow (Dupuit assumptions hold)
  \item Homogeneous, isotropic aquifer
  \item Constant \code{Tr}: Aquifer is confined, or if unconfined change in head is small relative to aquifer thickness
  \item Stream is straight, infinitely long, and remains in hydraulic connection to aquifer
  \item Constant stream stage
  \item No changes in recharge due to pumping
  \item No streambank storage
  \item Constant pumping rate
  \item Aquifer extends to infinity
}
}
\examples{
hunt(t = 1826, d = 1000, S = 0.2, Tr = 8640, lmda = 864)    # ~equal to glover because lmda=Tr
hunt(t = 1826, d = 1000, S = 0.2, Tr = 8640, lmda = 0.864)  # less depletion due to lower lmda

lmda <- streambed_conductance(w = 10, Kriv = 0.0864, briv = 1) # estimate lmda
hunt(t = 1826, d = 1000, S = 0.2, Tr = 8640, lmda = lmda)

Qf <- hunt(t = seq(1, 1826), d = 1000, S = 0.2, Tr = 8640, lmda = 0.864)
plot(x = seq(1, 1826), y = Qf, type = "l")
}
\references{
Hunt, B (1999). Unsteady Stream Depletion from Ground Water Pumping.
Ground Water 37 (1): 98-102. doi:10.1111/j.1745-6584.1999.tb00962.x.
}
