% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratbr.R
\name{BSSM_FD}
\alias{BSSM_FD}
\title{Optimal Allocation - Minimum Coefficient of Variation}
\usage{
BSSM_FD(Nh, Sh2x, n, H, nmin, X, takeall = FALSE)
}
\arguments{
\item{Nh}{Vector with number of population elements, or population size, in stratum h}

\item{Sh2x}{Vector with population variance of the variable X in stratum h.}

\item{n}{Sample size.}

\item{H}{Number of strata.}

\item{nmin}{Minimum sample size (smallest possible sample size in any stratum).}

\item{X}{Population Total}

\item{takeall}{Take-all stratum (takeall=TRUE) =>  nH=NH.}
}
\value{
\item{solution}{Vector with  sample of size by stratum and coefficient of variation
                       for the estimator of total of the stratification variable considered.}
}
\description{
Function that uses an integer programming formulation for allocation
      of the overall sample size n to the strata,  for the following purpose:
   Coefficient of Variation of the estimate of total for the survey variable is minimized.
}
\examples{
X<-round(100*runif(50))
Nh<-c(10,20,20)
Sh2x<-c(var(X[1:10]),var(X[11:30]),var(X[31:50]))
aloc1<-BSSM_FD(Nh,Sh2x,n=40,H=3,nmin=2,sum(X),takeall=TRUE)
Nh<-c(49,78,20,39,73,82,89)
X<-542350
Sh2x<-c(4436978,5581445,33454902,5763294,8689167,3716130,13938505)
aloc2<-BSSM_FD(Nh,Sh2x,n=100,H=7,nmin=2,X)
}
\references{
Brito, J.A.M, Silva, P.L.N.,Semaan, G.S. and Maculan, N. (2015).
           Integer Programming Formulations Applied to Optimal Allocation in Stratified Sampling.
           Survey Methodology, 41: 427-442.
}
\author{
Jose Brito (jambrito@gmail.com), Pedro Silva, Gustavo Semaan and Nelson Maculan.
}
