% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratastats.R
\name{stratastats}
\alias{stratastats}
\title{Stratified Analysis of 2x2 Contingency Tables}
\usage{
stratastats(
  input.data,
  variable.names = NULL,
  stratifying.variable.name = NULL,
  flip.or = FALSE,
  table.font.size = 13,
  source.note.font.size = 11
)
}
\arguments{
\item{input.data}{A list of 2x2 contingency tables or a 3-dimensional array where each 2x2 slice along the third
dimension represents a stratum.}

\item{variable.names}{Optional. A character vector containing the names of the two variables being cross-tabulated.
If not provided for a 3D array, they are extracted from the array's dimnames.
For a list of tables, these must be provided.}

\item{stratifying.variable.name}{Optional. A character vector containing the name of the stratifying variable.
If not provided for a 3D array, it is extracted from the array's dimnames.}

\item{flip.or}{Optional. Logical value indicating whether to flip the odds ratio (default is FALSE).
If TRUE, the reciprocal of the OR is calculated.}

\item{table.font.size}{Optional. Font size for the tables in the output (default is 13).}

\item{source.note.font.size}{Optional. Font size for the source notes in the output (default is 11).}
}
\value{
A list containing the following elements:
\itemize{
  \item \code{odds_ratios}: A data frame of odds ratios and their 95 percent confidence intervals for each stratum and the marginal table.
   \item \code{partial_chi_sq_results}: A character vector storing the result of the chi-squared test for each partial table.
   \item \code{marginal_chi_sq_result}: A character vector storing the result of the chi-squared test for the marginal table.
   \item \code{cmh_test_result}: Result of the Cochran-Mantel-Haenszel test, providing an overall measure of association
    while accounting for stratification.
   \item \code{breslow_day_test_result}: Result of the Breslow-Day-Tarone test, used to assess the homogeneity of the odds ratios
    across different strata.
  }
}
\description{
This function performs a comprehensive stratified analysis of 2x2 contingency tables. It calculates odds ratios (OR),
95 percent confidence intervals (CI), and conducts chi-squared tests, Cochran-Mantel-Haenszel (CMH) tests, and
Breslow-Day-Tarone tests for homogeneity of the odds ratios across strata. Additionally, it produces a
nicely-formatted table using the \code{\link[gt]{gt}} package, which includes both the results and their
interpretation, facilitating easier understanding and presentation of the analysis. The function is designed
to work with either a list of 2x2 tables or a 3-dimensional array representing stratified tables.\cr
Visit this \href{https://drive.google.com/file/d/1ofS6COi6RFzNm-0K5-uZqeRQN4gu0T-i/view?usp=sharing}{LINK} to access
the package's vignette.\cr
}
\details{
The function employs statistical techniques appropriate for stratified data analysis. The odds ratio for each stratum
and the combined strata (marginal table) are calculated. Confidence intervals are derived based on the standard
error of the log odds ratio. Chi-squared tests are conducted for each table to assess the association between the
variables at each level of the stratifying variable. The CMH test assesses the overall association while accounting for
stratification. The Breslow-Day-Tarone test, implemented from Michael Hoehle's function (see References), evaluates
the homogeneity of odds ratios across strata.\cr

The output includes a detailed breakdown of the odds ratios, confidence intervals, and test statistics for each
stratum and the marginal table. It also presents combined results with annotations explaining the significance and
implications of the tests.\cr

Interpretational Scenarios:\cr

1. Significant CMH test with homogeneity (non-significant Breslow-Day-Tarone test): Indicates conditional dependence and
consistent association across strata. The common odds ratio (from CMH test) is a reliable summary of the association.\cr

2. Significant CMH test with heterogeneity (significant Breslow-Day-Tarone test): Suggests conditional dependence and
varying strength or direction of association across strata (interaction), cautioning against a simple summary
of the association.\cr

3. Non-significant CMH test: Implies conditional independence.\cr

Note that the interpretation guidelines provided by the function are suggested based on the statistical tests' outcomes
and should be further evaluated within the context of your study.
}
\examples{

# EXAMPLE 1
# Survival on the Titanic

# create three individual partial tables

table1 <- matrix(c(118,5,61,139), byrow = TRUE, ncol=2)
table2 <- matrix(c(146,12,25,94), byrow = TRUE, ncol=2)
table3 <- matrix(c(418,110,75,106), byrow = TRUE, ncol=2)

# make a list

tables <- list(table1, table2, table3)

# specify the variable names

varnames <- c("Survival", "Gender")
stratvar <- "Class"

# carry out the analysis
results <- stratastats(input.data = tables, variable.names = varnames,
stratifying.variable.name = stratvar)


# EXAMPLE 2
# Smoking status and breathing test results (after Azen-Walker 2021)


table1 <- matrix(c(577, 34, 682, 57), byrow = TRUE, ncol=2)
table2 <- matrix(c(164,4,245,74), byrow = TRUE, ncol=2)

tables <- list(table1, table2)

varnames <- c("Smoking Status", "Breathing Test Result")
stratvar <- "Age"

results <-stratastats(input.data = tables, variable.names = varnames,
stratifying.variable.name = stratvar)

# EXAMPLE 3
# Admission to graduate school at Berkeley in 1973 (3-dimensional array).
# Since the array contains variables name and the name of the stratifying variable,
# all we need to feed into the function is the dataset name 'UCBAdmissions'. However,
# the name of the variables can be customised using either the 'variable.names'
# or 'stratifying.variable.name' # parameter, or both.

results <- stratastats(input.data = UCBAdmissions)


}
\references{
Azen, R., & Walker, C. M. (2021). Categorical data analysis for the behavioral and social sciences (2nd ed.).
New York: Routledge.

Breslow, N. E., & Day, N. E. (1980). Statistical methods in cancer research. Volume I -
The analysis of case-control studies. IARC Scientific Publications.

Hoehle, M. (2000). Breslow-Day-Tarone Test.
Retrieved from https://online.stat.psu.edu/onlinecourses/sites/stat504/files/lesson04/breslowday.test_.R

Lachin, J. M. (2000). Biostatistical methods: The assessment of relative risks. Wiley.
}
\seealso{
Refer to \code{\link{chisq.test}} for chi-squared tests, and to
\code{\link[stats]{mantelhaen.test}} for the Cochran-Mantel-Haenszel test.
}
\keyword{stratastats}
