% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{lm2v}
\alias{lm2v}
\title{List of Matrices to (Atomic) Vector}
\usage{
lm2v(
  lm,
  along = 2,
  use.listnames = TRUE,
  use.dimnames = TRUE,
  sep = "_",
  check = TRUE
)
}
\arguments{
\item{lm}{list of matrices. They do NOT have to be the same typeof or have the
same dimensions.}

\item{along}{numeric vector of length one that is equal to either 1 or 2.
1 means that each matrix in \code{lm} is split along rows (i.e., dimension 1)
and then concatenated. 2 means that each matrix in \code{lm} is split along columns
(i.e., dimension 2) and then concatenated.}

\item{use.listnames}{logical vector of length 1 specifying whether the returned
vector should have names based on the list the element came from. If \code{lm}
does not have names, \code{use.listnames} = TRUE will have the list positions
serve as the list names (e.g., "1", "2", "3", etc.)}

\item{use.dimnames}{logical vector of length 1 specifying whether the returned
vector should have named based on the dimnames of the matrix the element came from.
If a matrix within \code{lm} does not have dimnames, \code{use.dimnames} = TRUE
will have the dimension positions serve as the dimnames (e.g., "1", "2", "3", etc.)}

\item{sep}{character vector of length 1 specifying the string used to separate
the listnames and dimnames from each other when creating the names of the returned
vector.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{lm} is a list of matrices.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector with an element for each element from `lm`.
}
\description{
\code{lm2v} converts a list of matrices to a (atomic) vector. This function is
a combination of \code{m2v} and \code{lv2v}. This function can be useful in
conjunction with the \code{boot::boot} function when wanting to generate a
\code{statistic} function that returns an atomic vector.
}
\details{
When \code{list.names} and \code{use.dimnames} are both TRUE (default), the returned
vector elements the following naming scheme: "[listname][sep][rowname][sep][colname]".

If the matrices in \code{lm} are not all the same typeof, then the return object
is coerced to the most complex type of any matrix (e.g., character > double >
integer > logical). See \code{unlist} for details about the hierarchy of object types.
}
\examples{
lm <- list("numeric" = data.matrix(npk), "character" = as.matrix(npk))
# use.listnames = TRUE & use.dimnames = TRUE
lm2v(lm) # the first part of the name is the list names followed by the dimnames
# use.listnames = FALSE & use.dimnames = TRUE
lm2v(lm, use.listnames = FALSE) # only dimnames used,
   # which can result in repeat names
# use.listnames = TRUE & use.dimnames = FALSE
lm2v(lm, use.dimnames = FALSE) # listnames and vector position without any
   # reference to matrix dimensions
# use.listnames = FALSE & use.dimnames = FALSE
lm2v(lm, use.listnames = FALSE, use.dimnames = FALSE) # no names at all
# when list does not have names
lm <- replicate(n = 3, expr = as.matrix(attitude, rownames.force = TRUE), simplify = FALSE)
lm2v(lm) # the first digit of the names is the list position and
   # the subsequent digits are the matrix dimnames
lm2v(lm, use.listnames = FALSE) # no listnames; only dimnames used,
   # which can result in repeat names
}
