% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{ld2v}
\alias{ld2v}
\title{List of Data-Frames to (Atomic) Vector}
\usage{
ld2v(
  ld,
  along = 2,
  use.listnames = TRUE,
  use.dimnames = TRUE,
  sep = "_",
  fct = "chr",
  chr = "chr",
  lgl = "int",
  order.lvl = "alphanum",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{ld}{list of data.frames. They do NOT have to have the same dimensions.}

\item{along}{numeric vector of length one that is equal to either 1 or 2.
1 means that each data.frame in \code{ld} is split along rows (i.e., dimension 1)
and then concatenated. 2 means that each data.frame in \code{ld} is split along columns
(i.e., dimension 2) and then concatenated.}

\item{use.listnames}{logical vector of length 1 specifying whether the returned
vector should have names based on the list the element came from. If \code{ld}
does not have names, \code{use.listnames} = TRUE will have the list positions
serve as the list names (e.g., "1", "2", "3", etc.)}

\item{use.dimnames}{logical vector of length 1 specifying whether the returned
vector should have names based on the dimnames of the data.frame the element came from.
If a data.frame within \code{ld} does not have dimnames, \code{use.dimnames} = TRUE
will have the dimension positions serve as the dimnames (e.g., "1", "2", "3", etc.)}

\item{sep}{character vector of length 1 specifying the string used to separate
the listnames and dimnames from each other when creating the names of the returned
vector.}

\item{fct}{character vector of length 1 specifying what factors should be converted
to. There are three options: 1) "chr" for converting to character vectors (i.e.,
factor labels), 2) "int" for converting to integer vectors (i.e., factor codes),
or 3) "fct" for keeping the factor as is without any changes.}

\item{chr}{character vector of length 1 specifying what character vectors should
be converted to. There are three options: 1) "fct" for converting to factors (i.e.,
elements will be factor labels), 2) "int" for converting to integer vectors (i.e.,
factor codes after first converting to a factor), or 3) "chr" for keeping the
character vectors as is without any changes.}

\item{lgl}{character vector of length 1 specifying what logical vectors should
be converted to. There are four options: 1) "fct" for converting to factors (i.e.,
"TRUE" and "FALSE" will be factor labels), 2) "chr" for converting to character
vectors (i.e., elements will be "TRUE" and "FALSE"), 3) "int" for converting to
integer vectors (i.e., TRUE = 1; FALSE = 0), and 4) "lgl" for keeping the logical
vectors as is without any changes.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{ld} is a list of data.frames.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector with an element for each element from \code{ld}.
}
\description{
\code{ld2v} converts a list of data.frames to a (atomic) vector. This function is
a combination of \code{d2v} and \code{lv2v}. This function can be useful in
conjunction with the \code{boot::boot} function when wanting to generate a
\code{statistic} function that returns an atomic vector.
}
\details{
When \code{use.listnames} and \code{use.dimnames} are both TRUE (default), the returned
vector elements the following naming scheme: "[listname][sep][rowname][sep][colname]".

If the columns of the data.frames in \code{ld} are not all the same typeof, then
the return object is coerced to the most complex type of any data.frame column (e.g.,
character > double > integer > logical). See \code{unlist} for details about
the hierarchy of object types.
}
\examples{
ld <- list("cars" = cars, "mtcars" = mtcars)
# use.listnames = TRUE & use.dimnames = TRUE
ld2v(ld) # the first part of the name is the list names followed by the dimnames
# use.listnames = FALSE & use.dimnames = TRUE
ld2v(ld, use.listnames = FALSE) # only dimnames used,
   # which can result in repeat names
# use.listnames = TRUE & use.dimnames = FALSE
ld2v(ld, use.dimnames = FALSE) # listnames and vector position without any
   # reference to matrix dimensions
# use.listnames = FALSE & use.dimnames = FALSE
ld2v(ld, use.listnames = FALSE, use.dimnames = FALSE) # no names at all
# when list does not have names
ld <- replicate(n = 3, expr = attitude, simplify = FALSE)
ld2v(ld) # the first digit of the names is the list position and
   # the subsequent digits are the matrix dimnames
ld2v(ld, use.listnames = FALSE) # only dimnames used,
   # which can result in repeat names
}
