% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storywranglr.R
\name{ngrams}
\alias{ngrams}
\title{Explore Twitter trends with the Storywrangler ngrams API}
\usage{
ngrams(query, metric = c("rank", "freq"), language = "en", rt = c(FALSE, TRUE))
}
\arguments{
\item{query}{Character string with the n-gram(s) to query. One, two, or three
words separated by spaces will run query that string as a 1-gram, 2-gram,
or 3-gram respectively. More than three space-separated words will be
treated as separate queries for individual 1-grams.}

\item{metric}{The measure of lexical fame to return: accepts values \code{rank}
(default) and \code{freq}. \emph{Note:} API returns both by default.}

\item{language}{Two-letter code for the language to search. Defaults to \code{en}.}

\item{rt}{Boolean for whether to include retweets.}
}
\value{
A tibble with the API query and response.
}
\description{
Storywrangler's ngrams API lets you search a large historical database of
Twitter data for daily usage statistics about strings of one, two, and three
words (1-grams, 2-grams, and 3-grams respectively).

This function returns daily historical usage statistics for a given query
over data set's entire time range.

For more details about Storywrangler, please see:
\itemize{
\item API documentation: \url{https://github.com/janeadams/storywrangler}
\item Academic paper describing uses: \url{https://advances.sciencemag.org/content/7/29/eabe6534.full}
}
}
\examples{
\dontrun{
# Query a simple 1-gram about the populatity of potatoes
result <- ngrams("potatoes")

# Query a 2-gram about the popularity of potato chips
result <- ngrams("potato chips")

# Query *four* 1-grams related to potatoes
# Note! If there are more than 3 words, they are all treated as 1-grams
result <- ngrams("potato potahto spud taters")
}
}
