% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_remote.R
\name{driver_remote}
\alias{driver_remote}
\title{Remote storr}
\usage{
driver_remote(ops, ..., path_local = NULL)
}
\arguments{
\item{ops}{A file operations object.  See tests for now to see
what is required to implement one.}

\item{...}{Arguments to pass through to \code{\link{driver_rds}},
including \code{compress}, \code{mangle_key},
\code{mangle_key_pad} and \code{hash_algorithm}.}

\item{path_local}{Path to a local cache.  This can be left as
\code{NULL}, in which case a per-session cache will be used.
Alternatively, explicitly set to a path and the cache can be
reused over sessions.  Only storr \emph{values} (i.e., objects)
are cached - the key-to-value mapping is always fetched from the
remote storage.}
}
\description{
Create a storr that keeps rds-serialised objects on a remote
location.  This is the abstract interface (which does not do
anything useful) but which can be used with file operation driver
to store files elsewhere.  This is not intended for end-user use
so there is no \code{storr_remote} function.  Instead this
function is designed to support external packages that implement
the details.  For a worked example, see the package tests
(\code{helper-remote.R}).  In the current implementation these
build off of the \code{\link{driver_rds}} driver by copying files
to some remote location.
}
\author{
Rich FitzJohn
}
