% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ticker_dates.R
\name{ticker_dates}
\alias{ticker_dates}
\title{Get Yahoo! Finance Start/End Dates for Tickers}
\usage{
ticker_dates(tickers, from = "1950-01-01", to = Sys.Date())
}
\arguments{
\item{tickers}{Character vector with ticker symbols that Yahoo! Finance 
recognizes.}

\item{from}{Date or character string (e.g. \code{"2015-01-15"}.}

\item{to}{Date or character string (e.g. \code{"2016-01-30"}).}
}
\value{
Data frame with ticker symbol, start date, end date, and number of 
trading days for each ticker.
}
\description{
Typically useful for determining a time period over which to compare several 
funds.
}
\examples{
# See what dates are available for Apple and Amazon
ticker_dates(c("AAPL", "AMZN"))


}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
