% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{stoRy_opt}
\alias{stoRy_opt}
\title{Set \pkg{stoRy} package global options}
\usage{
stoRy_opt(x)
}
\arguments{
\item{x}{A character string holding an option name. The possible values are
\code{"width"}, \code{"print_min"}, and \code{"print_max"}.}
}
\description{
\code{stoRy_opt()} sets \pkg{stoRy} package global options.
}
\details{
The package options control the formatting of the \code{\link[=Story]{Story()}}, \code{\link[=Theme]{Theme()}},
\code{\link[=Collection]{Collection()}}, and \code{\link[=Themeset]{Themeset()}} R6 classes when printing to console. The
options are as follows:
\tabular{ll}{
\code{width}: \tab The column width in characters of printed to console
output (78 characters by default)\cr
\code{print_min}: \tab The minimum number of entries to print to console (10
characters by default)\cr
\code{print_max}: \tab The maximum number of entries to print to console (100
characters by default)\cr
}
}
\examples{
\dontrun{
# Check the current option values:
stoRy_opt("width")
stoRy_opt("print_min")
stoRy_opt("print_max")

# Set the column width to 120 characters:
options(stoRy.width = 120L) 

# Set the minimum number of printed entries to be 25:
options(stoRy.print_min = 25L) 
 
# Set the maximum number of printed entries to be 250:
options(stoRy.print_max = 250L)
}
}
\seealso{
Use \code{\link[=Story]{Story()}} to initialize an LTO thematically annotated story.

Use \code{\link[=Theme]{Theme()}} to initialize an LTO theme.

Use \code{\link[=Collection]{Collection()}} to initialize an collection of LTO thematically
annotated stories.

Use \code{\link[=Themeset]{Themeset()}} to initialize a set of related LTO themes.
}
