% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_featured_themes.R
\name{get_featured_themes}
\alias{get_featured_themes}
\title{Find the most frequently occurring themes in a collection}
\usage{
get_featured_themes(
  collection = NULL,
  top_m = 10,
  weights = list(choice = 3, major = 2, minor = 1),
  explicit = TRUE,
  min_freq = 1,
  blacklist = NULL
)
}
\arguments{
\item{collection}{A \code{\link[=Collection]{Collection()}} class object.

If \code{NULL}, the collection of all stories in the actively loaded
\acronym{LTO} version is used.}

\item{top_m}{Maximum number of themes to report. The default is \code{top_m=10}.

If \code{Inf}, all themes occurring at least \code{min_occurrence} times in the
collection are reported.}

\item{weights}{A list assigning nonnegative weights to choice, major, and
minor theme levels. The default weighting
\code{list(choice = 3, major = 2, minor = 1)} counts each \emph{choice} usage
three times, each \emph{major} theme usage twice, and each \emph{minor}
theme usage once. Use the uniform weighting
\code{list(choice = 1, major = 1, minor = 1)} weights theme usages equally
regardless of level. At least one weight must be positive.}

\item{explicit}{Set to \code{FALSE} to include ancestor themes of the explicit
thematic annotations.}

\item{min_freq}{Drop themes occurring less than this number of times from
the analysis. The default \code{min_freq=1} results in no themes are discarded.}

\item{blacklist}{A \code{\link[=Themeset]{Themeset()}} class object. A themeset containing themes
to be dropped from the analysis.

If \code{NULL}, no themes are filtered.}
}
\value{
Returns a \code{\link[tibble]{tibble}} with \code{top_m} rows (themes)
and 6 columns:
\tabular{ll}{
\code{theme_name}: \tab \code{m}-th most frequently occurring theme in the
collection\cr
\code{k}: \tab Number of collection stories featuring the theme\cr
\code{k_bar}: \tab Weighted counts of the theme summed over the collection
stories\cr
\code{n}: \tab Number of stories in the collection\cr
\code{n_bar}: \tab Sum of all weighted counts of collection themes\cr
\code{tp}: \tab Theme weighted term proportion (i.e. \code{k_bar}/\code{n_bar})\cr
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_featured_themes()} calculates the top \code{m} most frequently occurring
themes in a collection.
}
\details{
The input collection of \code{n} stories, \eqn{S[1], \ldots, S[n]}, is
represented as a weighted bag-of-words, where each \emph{choice} theme in
story \eqn{S[j] (j=1, \ldots, n)} is counted \code{weights$choice} times,
each \emph{major} theme \code{weights$major} times, and each \emph{minor}
theme \code{weights$choice} times.
}
\examples{
\dontrun{
# Retrieve the top 10 most featured themes in "The Twilight Zone" franchise
# stories:
set_lto("demo")
result_tbl <- get_featured_themes()
result_tbl

# Retrieve the top 10 most featured themes in "The Twilight Zone" franchise
# stories not including any minor level themes:
set_lto("demo")
result_tbl <- get_featured_themes(weights = list(choice = 1, major = 1, minor = 0))
result_tbl

# Retrieve the top 10 most featured themes in "The Twilight Zone" (1959)
# television series episodes:
collection <- Collection$new(collection_id = "Collection: tvseries: The Twilight Zone (1959)")
result_tbl <- get_featured_themes(collection)
result_tbl
}
}
