% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_theme.R
\docType{class}
\name{Theme}
\alias{Theme}
\title{R6 class representing an LTO literary theme}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

The \pkg{stoRy} package uses the \code{Theme} R6 class to represent individual
LTO literary themes. This class is mostly useful for accessing information
about an LTO theme for which the theme name is known in advance.
}
\details{
The class operates on the themes of whichever LTO version happens to be
actively loaded into the \pkg{stoRy} package level environment. This is
the LTO \code{demo} version by default. Run \code{\link[=which_lto]{which_lto()}} to check which LTO
version is active in your R session.

Search the latest LTO \code{dev} version themes on the Theme Ontology website at
\url{https://www.themeontology.org/themes}.
}
\examples{
\dontrun{
# Initialize an LTO `demo` version theme pertaining to Martians:
set_lto("demo")
theme <- Theme$new(theme_name = "Martian extraterrestrial")

# Print theme info to console:
theme

# Print theme info to console in the canonical th.txt format:
theme$print(canonical = TRUE)

# Return the theme description:
theme$description()

# Return references associated with the description, if any:
theme$references()

# Return theme name aliases, if any:
theme$aliases()

# Return the theme's parent theme names:
theme$parents()

# Return the theme's ancestor theme names:
theme$ancestors()

# Return a tibble of thematically annotated stories:
theme$annotations()
}
}
\seealso{
Use \code{\link[=Collection]{Collection()}} to initialize an collection of LTO thematically
annotated stories.

Use \code{\link[=Story]{Story()}} to initialize an LTO thematically annotated story.

Use \code{\link[=Themeset]{Themeset()}} to initialize a set of related LTO themes.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Theme-new}{\code{Theme$new()}}
\item \href{#method-Theme-theme_name}{\code{Theme$theme_name()}}
\item \href{#method-Theme-aliases}{\code{Theme$aliases()}}
\item \href{#method-Theme-description}{\code{Theme$description()}}
\item \href{#method-Theme-notes}{\code{Theme$notes()}}
\item \href{#method-Theme-references}{\code{Theme$references()}}
\item \href{#method-Theme-examples}{\code{Theme$examples()}}
\item \href{#method-Theme-parents}{\code{Theme$parents()}}
\item \href{#method-Theme-ancestors}{\code{Theme$ancestors()}}
\item \href{#method-Theme-source}{\code{Theme$source()}}
\item \href{#method-Theme-annotations}{\code{Theme$annotations()}}
\item \href{#method-Theme-print}{\code{Theme$print()}}
\item \href{#method-Theme-clone}{\code{Theme$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-new"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-new}{}}}
\subsection{Method \code{new()}}{
Initialize an LTO theme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$new(theme_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theme_name}}{A length-one character vector corresponding to an LTO
theme name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Theme} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-theme_name"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-theme_name}{}}}
\subsection{Method \code{theme_name()}}{
return A length-one character vector corresponding to the theme name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$theme_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-aliases"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-aliases}{}}}
\subsection{Method \code{aliases()}}{
return A tibble of theme name aliases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$aliases()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-description"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-description}{}}}
\subsection{Method \code{description()}}{
return A length-one character vector corresponding to the theme
description.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$description()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-notes"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-notes}{}}}
\subsection{Method \code{notes()}}{
return A tibble of caveats that accompany that theme description. This
is empty for the vast majority of themes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$notes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-references"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-references}{}}}
\subsection{Method \code{references()}}{
return A tibble of references.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$references()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-examples"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-examples}{}}}
\subsection{Method \code{examples()}}{
return A tibble of example usages of the theme, if any.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$examples()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-parents"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-parents}{}}}
\subsection{Method \code{parents()}}{
return A tibble of the theme's parent theme names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$parents()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-ancestors"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-ancestors}{}}}
\subsection{Method \code{ancestors()}}{
return A tibble of the theme's ancestor theme names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$ancestors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-source"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-source}{}}}
\subsection{Method \code{source()}}{
return The path of the th.txt file containing the theme. This is the
file path as it occurs on the Theme Ontology GitHub repository at
\url{https://github.com/theme-ontology/theming}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$source()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-annotations"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-annotations}{}}}
\subsection{Method \code{annotations()}}{
return A tibble with one row for each story in which the theme is
featured. The first column is the LTO story ID, the second is the
release data, the third is the level (choice/major/minor) at which
the theme is featured, and the fourth a justification for applying
the theme. Each column is of type character.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$annotations()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-print"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-print}{}}}
\subsection{Method \code{print()}}{
Print theme object info to console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$print(canonical = FALSE, width = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{canonical}}{Set to FALSE for pretty output.}

\item{\code{width}}{Width of text output to generate. This defaults to NULL,
which means the \code{stoRy_opt("width")} value is used. Run
\code{options(stoRy.width = 120L)} to change the column width to be 120
characters, etc.}

\item{\code{...}}{Additional arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Theme-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Theme-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Theme$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
