% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_story.R
\docType{class}
\name{Story}
\alias{Story}
\title{R6 class representing an LTO thematically annotated story}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

The \pkg{stoRy} package uses the \code{Story} R6 class to represent the LTO
thematic annotations for individual works of fiction. This class is mostly
useful for accessing information about an LTO thematically annotated story
for which the story ID is known in advance.
}
\details{
The class operates on the stories of whichever LTO version happens to be
actively loaded into the \pkg{stoRy} package level environment. This is
the LTO \code{demo} version by default. Run \code{\link[=which_lto]{which_lto()}} to check which LTO
version is active in your R session.

Search the latest LTO \code{dev} version stories on the Theme Ontology website
at \url{https://www.themeontology.org/stories}.
}
\examples{
\dontrun{
# Initialize the LTO `demo` version of a classic The Twilight Zone (1959) story:
set_lto("demo")
story <- Story$new(story_id = "tz1959e1x22")

# Print story info and thematic annotations to console:
story

# Print story info and thematic annotations in st.txt format:
story$print(canonical = TRUE)

# Return the story title:
story$title()

# Return the story description:
story$description()

# Return a tibble of thematic annotations:
story$themes()
}
}
\seealso{
Use \code{\link[=Collection]{Collection()}} to initialize an collection of LTO thematically
annotated stories.

Use \code{\link[=Theme]{Theme()}} to initialize an LTO theme.

Use \code{\link[=Themeset]{Themeset()}} to initialize a set of related LTO themes.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Story-new}{\code{Story$new()}}
\item \href{#method-Story-story_id}{\code{Story$story_id()}}
\item \href{#method-Story-title}{\code{Story$title()}}
\item \href{#method-Story-description}{\code{Story$description()}}
\item \href{#method-Story-date}{\code{Story$date()}}
\item \href{#method-Story-references}{\code{Story$references()}}
\item \href{#method-Story-collections}{\code{Story$collections()}}
\item \href{#method-Story-themes}{\code{Story$themes()}}
\item \href{#method-Story-source}{\code{Story$source()}}
\item \href{#method-Story-obj_internal_tbl}{\code{Story$obj_internal_tbl()}}
\item \href{#method-Story-print}{\code{Story$print()}}
\item \href{#method-Story-clone}{\code{Story$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-new"></a>}}
\if{latex}{\out{\hypertarget{method-Story-new}{}}}
\subsection{Method \code{new()}}{
Initialize an LTO thematically annotated story.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$new(story_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{story_id}}{A length-one character vector corresponding to the ID
of an LTO thematically annotated work of fiction.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Story} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-story_id"></a>}}
\if{latex}{\out{\hypertarget{method-Story-story_id}{}}}
\subsection{Method \code{story_id()}}{
return A length-one character vector corresponding to the story ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$story_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-title"></a>}}
\if{latex}{\out{\hypertarget{method-Story-title}{}}}
\subsection{Method \code{title()}}{
return A length-one character vector corresponding to the story title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$title()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-description"></a>}}
\if{latex}{\out{\hypertarget{method-Story-description}{}}}
\subsection{Method \code{description()}}{
return A length-one character vector corresponding to some summary
information about the story. This is typically a synopsis and/or
details about the authorship, production, distribution, etc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$description()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-date"></a>}}
\if{latex}{\out{\hypertarget{method-Story-date}{}}}
\subsection{Method \code{date()}}{
return A length-one character vector corresponding to the story release
date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$date()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-references"></a>}}
\if{latex}{\out{\hypertarget{method-Story-references}{}}}
\subsection{Method \code{references()}}{
return A tibble of story reference urls, if any.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$references()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-collections"></a>}}
\if{latex}{\out{\hypertarget{method-Story-collections}{}}}
\subsection{Method \code{collections()}}{
return A tibble of LTO collections to which the story belongs, if any.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$collections()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-themes"></a>}}
\if{latex}{\out{\hypertarget{method-Story-themes}{}}}
\subsection{Method \code{themes()}}{
return A tibble of thematic annotations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$themes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-source"></a>}}
\if{latex}{\out{\hypertarget{method-Story-source}{}}}
\subsection{Method \code{source()}}{
return The path of the st.txt file containing the story thematic
annotations. This is the file path as it occurs on the Theme Ontology
GitHub repository at \url{https://github.com/theme-ontology/theming}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$source()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-obj_internal_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-Story-obj_internal_tbl}{}}}
\subsection{Method \code{obj_internal_tbl()}}{
return A special tibble that is used internally by package functions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$obj_internal_tbl()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-print"></a>}}
\if{latex}{\out{\hypertarget{method-Story-print}{}}}
\subsection{Method \code{print()}}{
Print story object info to console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$print(canonical = FALSE, width = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{canonical}}{Set to FALSE for pretty output.}

\item{\code{width}}{Width of text output to generate. This defaults to NULL,
which means the \code{stoRy_opt("width")} value is used. Run
\code{options(stoRy.width = 120L)} to change the column width to be 120
characters, etc.}

\item{\code{...}}{Additional arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Story-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Story-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Story$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
