% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_story.r
\docType{class}
\name{story}
\alias{story}
\title{Story objects}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
story
}
\arguments{
\item{story}{The object is typically created by passing a story ID from any of the 
Star Trek TOS/TAS/TNG series to construct the object automatically from system data.  
A user-defined story IDs may alos be accepted in which case the fields will be empty,
if not supplied by the user.}
}
\description{
The \pkg{stoRy} package uses the \code{story} object to store
story themes and other meta-data.
}
\section{Fields}{


Each story object has the following ten fields
\describe{
\item{story_id}{A story ID. See examples.}
\item{title}{A string giving the story title.}
\item{writer}{A string giving the story writer.}
\item{director}{A string giving the story director.}
\item{original_air_date}{A string giving the story original air date in the forr YYYY-MM-DD}
\item{summary}{A string giving a summary of the story.}
\item{characters}{A list of story characters. The list has three fields: \code{ObjectCharacters},
\code{MajorCharacters}, and \code{MinorCharacters}. Each list entry should be a ", " separated string
of character names.}
\item{themes}{A data frame of story themes with associated meta-data.}
\item{settings}{A data frame of story settings with associated meta-data.}
\item{keywords}{A data frame of story keywords with associated meta-data.}}
}

\examples{
########################################################################
# Create a story object for the Star Trek The Original Series episode  #
# TOS1x19 "The Arena" and manipulate it in various ways                #
########################################################################
story_id <- "TOS1x19"
mystory <- story$new(story_id)
print(mystory)
# Add "pride" as a minor theme
mystory$add_theme(theme = "pride", level = "minor")
# Remove "pride" as a minor theme on second thought
mystory$remove_theme(theme = "pride")
# Add "candy shop" as a setting
mystory$add_setting(setting = "candy shop")
# Remove "candy shop" as a setting
#' mystory$remove_setting(setting = "candy shop")
# Add a new keyword
mystory$add_keyword(keyword = "Captain Kirk is climbing a mountain")
}
\keyword{datasets}
