% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchK.R
\name{searchK}
\alias{searchK}
\title{Computes diagnostic values for models with different values of K (number of
topics).}
\usage{
searchK(documents, vocab, K, init.type = "Spectral", N = floor(0.1 *
  length(documents)), proportion = 0.5, heldout.seed = NULL, M = 10,
  cores = 1, ...)
}
\arguments{
\item{documents}{The documents to be used for the stm model}

\item{vocab}{The vocabulary to be used for the stmmodel}

\item{K}{A vector of different topic numbers}

\item{init.type}{The method of initialization. See \code{\link{stm}} for
options.  Note that the default option here is different from the main
function.}

\item{N}{Number of docs to be partially held out}

\item{proportion}{Proportion of docs to be held out.}

\item{heldout.seed}{If desired, a seed to use when holding out documents for
later heldout likelihood computation}

\item{M}{M value for exclusivity computation}

\item{cores}{Number of CPUs to use for parallel computation}

\item{...}{Other diagnostics parameters.}
}
\value{
\item{exclus}{Exclusivity of each model.} \item{semcoh}{Semantic
coherence of each model.} \item{heldout}{Heldout likelihood for each model.}
\item{residual}{Residual for each model.} \item{bound}{Bound for each
model.} \item{lbound}{lbound for each model.} \item{em.its}{Total number of
EM iterations used in fiting the model.}
}
\description{
With user-specified initialization, this function runs selectModel for
different user-specified topic numbers and computes diagnostic properties
for the returned model. These include exclusivity, semantic coherence,
heldout likelihood, bound, lbound, and residual dispersion.
}
\details{
See the vignette for interpretation of each of these measures.  Each of
these measures is also available in exported functions:
\describe{
\item{exclusivity}{\code{\link{exclusivity}}}
\item{semantic coherence}{\code{\link{semanticCoherence}}}
\item{heldout likelihood}{\code{\link{make.heldout}} and \code{\link{eval.heldout}}}
\item{bound}{calculated by \code{\link{stm}} accessible by \code{max(model$convergence$bound)}}
\item{lbound}{a correction to the bound that makes the bounds directly comparable \code{max(model$convergence$bound) + lfactorial(model$settings$dim$K)}}
\item{residual dispersion}{\code{\link{checkResiduals}}}
}

Due to the need to calculate the heldout-likelihood \code{N} documents have
\code{proportion} of the documents heldout at random.  This means that even
with the default spectral initialization the results can change from run to run.
When the number of heldout documents is low or documents are very short, this also
means that the results can be quite unstable.  For example: the \code{gadarian} code
demonstration below has heldout results based on only 34 documents and approximately
150 tokens total.  Clearly this can lead to quite disparate results across runs.  By 
contrast default settings for the \code{poliblog5k} dataset would yield a heldout sample
of 500 documents with approximately 50000 tokens for the heldout sample.  We should expect
this to be substantially more stable.
}
\examples{

\dontrun{

K<-c(5,10,15) 
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta)
documents <- out$documents
vocab <- out$vocab
meta <- out$meta
set.seed(02138)
K<-c(5,10,15) 
kresult <- searchK(documents, vocab, K, prevalence=~treatment + s(pid_rep), data=meta)
plot(kresult)

}
 
}
\seealso{
\code{\link{plot.searchK}} \code{\link{make.heldout}}
}
