% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2d_smooth.R
\name{plot_2d_smooth}
\alias{plot_2d_smooth}
\title{Plots a 2-Dimensional GAM smooth}
\usage{
plot_2d_smooth(mod, filled = FALSE, outline = NULL, ncol = NULL, nrow = NULL)
}
\arguments{
\item{mod}{a GAM model with smooths created using the \code{mgcv} package}

\item{filled}{\code{logical} value to indicate whether a filled plot should be created (\code{TRUE}) or not (\code{FALSE})}

\item{outline}{the name of an \code{sf} object to be plotted (NULL is the default)}

\item{ncol}{the number of columns for the compound plot}

\item{nrow}{the number of rows for the compound plot}
}
\value{
A compound plot of the 2-dimensional smooths (rendered using \code{cowplot::plot_grid}).
}
\description{
Plots a 2-Dimensional GAM smooth
}
\examples{
library(mgcv)
library(ggplot2)
library(dplyr)
library(metR)
library(cowplot)
set.seed(2) ## simulate some data...
dat <- gamSim(1,n=400,dist="normal",scale=2)
# use x1 and x2 as the coordinates
b <- gam(y~s(x0, x1, bs = 'gp', by = x2),data=dat)
plot_2d_smooth(b, filled = TRUE)
}
