% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corvectors.R
\name{corvectors}
\alias{corvectors}
\title{Create multivariate data by permutation}
\usage{
corvectors(
  data,
  corm,
  tol = 0.005,
  conv = 10000,
  cores = 2,
  splitsize = 1000,
  verbose = FALSE,
  seed
)
}
\arguments{
\item{data}{a data matrix containing the data}

\item{corm}{A value containing the desired correlation or a vector or data matrix containing the desired correlations}

\item{tol}{A single value or a vector of tolerances with length \code{ncol(data) - 1}. The default is 0.005}

\item{conv}{The maximum iterations allowed. Defaults to 1000.}

\item{cores}{The number of cores to be used for parallel computing}

\item{splitsize}{The size to use for splitting the data}

\item{verbose}{Logical statement. Default is FALSE}

\item{seed}{An optional seed to set}
}
\value{
\code{corvectors()} returns a matrix given the specified multivariate relation.
}
\description{
\code{corvectors()} is a function to obtain a multivariate dataset by specifying
the relation between those specified variables.
}
\details{
This is liberally copy-pasted from van Kooten and Vink's wonderful-but-no-longer-supported \pkg{correlate} package.
They call it \code{correlate()} in their package, but I opt for \code{corvectors()} here.
}
\examples{

\donttest{
# bivariate example, start with zero correlation
corvectors(replicate(2, rnorm(100)), .5)

# multivariate example

corvectors(replicate(4, rnorm(100)), c(.5, .6, .7))

}

}
\author{
Pascal van Kooten and Gerko Vink
}
