% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_proportion_functions-class.R
\name{set_proportion_dispersing}
\alias{set_proportion_dispersing}
\title{Set proportions of populations dispersing}
\usage{
set_proportion_dispersing(proportions = 1)
}
\arguments{
\item{proportions}{A single value or vector of proportions (between zero and one) of
individuals in each life stage that disperse - default is 1. If proportions are specified
as a single number, then all life-stages disperse with that proportion, however, a vector
of proportions (equal in length to the number of life-stages) can also be specified. To
prevent stages from dispersing, set corresponding values to zero.}
}
\value{
An object of class \code{dispersal_proportion_function}
}
\description{
This function allows a user to specify what proportions of populations in each life-stage disperse.
It operates similarly on all cells and in all timesteps throughout a simulation.
}
\examples{

# Example of a proportion function that disperses no population in the first life stage,
# 50\% of the second, and 90\% of the 3rd. 

\dontrun{
prop_dispersal <- set_proportion_dispersing(proportions = c(0, 0.5, 0.9))

kb_dispersal <- kernel_dispersal(dispersal_proportion = prop_dispersal,
                      max_distance = 2000,
                      dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1000))

ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat), dispersal = kb_dispersal)

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
