% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get_weights}
\alias{get_weights}
\title{Mesh weights}
\usage{
get_weights(mesh, sf, plot = FALSE)
}
\arguments{
\item{mesh}{A spatial mesh of class \code{INLA::inla.mesh.2d()} or
\code{INLA::inla.mesh()}.}

\item{sf}{An \code{sf} of type \code{POLYGON} specifying the region
of the domain.}

\item{plot}{Logical, whether to plot the calculated \code{mesh} weights. 
Default, \code{FALSE}.}
}
\value{
Either a simple features, \code{sf}, object or values returned by \code{geom_sf}.
}
\description{
Calculate the  areas (weights) around the mesh nodes that 
are within the specified spatial polygon \code{sf} of the domain.
}
\examples{
data(horse_mesh, package = "stelfi")
data(horse_sf, package = "stelfi")
get_weights(horse_mesh, horse_sf, plot = TRUE)
}
\seealso{
\url{https://becarioprecario.bitbucket.io/spde-gitbook/}.
}
