% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rfca_options.R
\name{rfca_options}
\alias{rfca_options}
\title{Simulations using \code{rfca()}}
\usage{
rfca_options(data, rfca.options.list, verbose)
}
\arguments{
\item{data}{a data frame}

\item{rfca.options.list}{a named list containing \code{rfca()} arguments
and the values with which they should be simulated; list should be initially
produced by a call to \code{rfca_args()}}

\item{verbose}{logical; if TRUE, will print extra execution informaton}
}
\value{
Returns a named list containing the following elements:

\item{\code{opts}}{a data frame containing the parameter values used for each execution}
\item{\code{results}}{a list of \code{rfca()} solutions}
}
\description{
\code{rfca_options} repeatedly executes the \code{rfca()} function
over a number of different argument values and returns its solutions
}
\examples{
# Load data
data(hicks_20)

# Generate list of eqmcc arguments
arglist<-rfca_args()

# Specify values for execution
arglist$outcome<-"CON"
arglist$case.ids<-"Case"
arglist$ntree<-c(1,5,100,5000)
arglist$mtry<-c(1,5,10,20)

# Run execution
a<-rfca_options(data = hicks_20, rfca.options.list = arglist)

# Get data frame of parameter values
a$opts

# Get the solutions for parameter specifications in row 6
a$opts[4,]
a$results[[4]]
}

