% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.gam.R
\name{scatter.gam}
\alias{scatter.gam}
\title{Scatter Plot with GAM Smooth Line}
\usage{
scatter.gam(
  x,
  y,
  data.dots = TRUE,
  three.dots = FALSE,
  data = NULL,
  k = NULL,
  plot.dist = NULL,
  dot.pch = 16,
  dot.col = adjustcolor("gray", 0.7),
  jitter = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric vector of x values, or a formula of the form \code{y ~ x}.}

\item{y}{A numeric vector of y values. Not used if \code{x} is a formula.}

\item{data.dots}{Logical. If TRUE, displays data on scatterplot}

\item{three.dots}{Logical. If TRUE, divides x into tertiles and puts markers on the average  x & y for each}

\item{data}{An optional data frame containing the variables \code{x} and \code{y}.}

\item{k}{Optional integer specifying the basis dimension for the smooth term
in the GAM model (passed to \code{s(x, k=k)}). If NULL (default), uses the
default basis dimension.}

\item{plot.dist}{Character string specifying how to plot the distribution of \code{x}
underneath the scatter plot. Options: \code{NULL} (default, auto-select based on
number of unique values), \code{"none"} (no distribution plot), \code{"plot_freq"}
(always use \code{plot_freq()}), or \code{"hist"} (always use \code{hist()}).
When \code{NULL}, uses \code{plot_freq()} if there are 25 or fewer unique values,
otherwise uses \code{hist()}.}

\item{dot.pch}{Plotting character for data points when \code{data.dots = TRUE}.
Default is 16 (filled circle).}

\item{dot.col}{Color for data points when \code{data.dots = TRUE}. Default is
\code{adjustcolor('gray', 0.7)} (semi-transparent gray).}

\item{jitter}{Logical. If TRUE, applies a small amount of jitter to data points
to reduce overplotting. Default is FALSE.}

\item{...}{Additional arguments passed to \code{plot()} and \code{gam()}.
Common plot arguments include:
\itemize{
  \item \code{main}: Custom title for the plot (e.g., \code{main = "My Title"})
  \item \code{col}: Color of the GAM smooth line (e.g., \code{col = "red"})
  \item \code{lwd}: Line width of the GAM smooth line (e.g., \code{lwd = 2})
  \item \code{xlim}, \code{ylim}: Axis limits (e.g., \code{xlim = c(0, 10)})
  \item \code{xlab}, \code{ylab}: Axis labels (e.g., \code{xlab = "Age"})
}}
}
\value{
Invisibly returns the fitted GAM model object.
}
\description{
Creates a scatter plot with a GAM (Generalized Additive Model) smooth line.
Supports both \code{scatter.gam(x, y)} and \code{scatter.gam(y ~ x)}.
}
\details{
This function fits a GAM model with a smooth term for x and plots the fitted
smooth line. The function uses the \code{mgcv} package's \code{gam()} function.

When \code{three.dots = TRUE}, the x variable is divided into three equal-sized
groups (tertiles), and the mean x and y values for each group are plotted as
points. This provides a simple summary of the relationship across the range of x.
}
\examples{
# Generate sample data for examples
x <- rnorm(100)
y <- 2*x + rnorm(100)

# Plot GAM smooth line only
scatter.gam(x, y)

# Equivalent call using formula syntax (y ~ x)
scatter.gam(y ~ x)

# Include scatter plot with underlying data points behind the GAM line
scatter.gam(x, y, data.dots = TRUE)

# Include summary points showing mean x and y for each tertile bin
scatter.gam(x, y, three.dots = TRUE)

# Customize the plot with a custom title, line color, and line width
scatter.gam(x, y, data.dots = TRUE, col = "red", lwd = 2, main = "GAM Fit")

# Control smoothness of the GAM line by specifying the basis dimension
scatter.gam(x, y, k = 10)

}
\seealso{
\code{\link[stats]{scatter.smooth}} for a simpler loess-based scatter plot smoother.
}
