% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_inference.R
\name{bayes_inference}
\alias{bayes_inference}
\title{Bayesian hypothesis tests and credible intervals}
\usage{
bayes_inference(
  y,
  x = NULL,
  data,
  type = c("ci", "ht"),
  statistic = c("mean", "proportion"),
  success = NULL,
  null = NULL,
  cred_level = 0.95,
  alternative = c("twosided", "less", "greater"),
  hypothesis_prior = c(H1 = 0.5, H2 = 0.5),
  n_0 = 1,
  beta_prior = NULL,
  beta_prior1 = NULL,
  beta_prior2 = NULL,
  verbose = TRUE,
  show_summ = verbose,
  show_res = verbose,
  show_plot = verbose
)
}
\arguments{
\item{y}{Response variable, can be numerical or categorical}

\item{x}{Explanatory variable, categorical (optional)}

\item{data}{Name of data frame that y and x are in}

\item{type}{of inference; "ci" (credible interval) or "ht" (hypothesis test)}

\item{statistic}{population parameter to estimate: mean or proportion}

\item{success}{which level of the categorical variable to call "success", i.e. do inference on}

\item{null}{null value for the hypothesis test}

\item{cred_level}{confidence level, value between 0 and 1}

\item{alternative}{direction of the alternative hypothesis; "less","greater", or "twosided"}

\item{hypothesis_prior}{discrete prior for H1 and H2, default is the uniform prior: c(H1=0.5,H2=0.5)}

\item{n_0}{Prior sample size for calculating the Bayes factor of the twosided test of one mean}

\item{beta_prior, beta_prior1, beta_prior2}{beta priors for p (or p_1 and p_2) for one or two proportion inference}

\item{verbose}{whether output should be verbose or not, default is TRUE}

\item{show_summ}{print summary stats, set to verbose by default}

\item{show_res}{print results, set to verbose by default}

\item{show_plot}{print inference plot, set to verbose by default}
}
\value{
Results of inference task performed
}
\description{
Bayesian hypothesis tests and credible intervals
}
