% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.slope.mean.bs}
\alias{ci.slope.mean.bs}
\title{Confidence interval for the slope of means in a one-factor experimental
design with a quantitative between-subjects factor}
\usage{
ci.slope.mean.bs(alpha, m, sd, n, x)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of sample means}

\item{sd}{vector of sample standard deviations}

\item{n}{vector of sample sizes}

\item{x}{vector of numeric predictor variable values}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated slope
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a test statistic and confidence interval for the slope of means in
a one-factor experimental design with a quantitative between-subjects
factor. This function computes both the unequal variance and equal variance
confidence intervals and test statistics. A Satterthwaite adjustment to the
degrees of freedom is used with the unequal variance method.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
n <- c(10,10,10,10)
x <- c(5, 10, 20, 30)
ci.slope.mean.bs(.05, m, sd, n, x)

# Should return:
#                               Estimate         SE        t       df
# Equal Variances Assumed:     0.3664407 0.06770529 5.412290 36.00000
# Equal Variances Not Assumed: 0.3664407 0.07336289 4.994905 18.65826
#                                         p        LL        UL
# Equal Variances Assumed:     4.242080e-06 0.2291280 0.5037534
# Equal Variances Not Assumed: 8.468223e-05 0.2126998 0.5201815


}
