% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.oddsratio}
\alias{ci.oddsratio}
\title{Confidence interval for an odds ratio}
\usage{
ci.oddsratio(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of odds ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for an odds ratio with .5 added to each
cell frequency. This function requires the frequency counts from a
2 x 2 contingency table for two dichotomous variables.
}
\examples{
ci.oddsratio(.05, 229, 28, 96, 24)

# Should return:
#      Estimate       LL       UL
# [1,] 2.044451 1.133267 3.688254


}
\references{
\insertRef{Fleiss2003}{statpsych}
}
