% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.supinf.prop2}
\alias{size.supinf.prop2}
\title{Sample size for a 2-group superiority or inferiority test of proportions}
\usage{
size.supinf.prop2(alpha, pow, p1, p2, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{h}{lower or upper limit for range of practical equivalence}
}
\value{
Returns the required sample size per group
}
\description{
Computes the sample size in each group required to perform a superiority
or inferiority test for the difference in population proportions with
desired power in a 2-group design. For a superiority test, specify the
upper limit (h) for the range of practical equivalence and specify values
of p1 and p2 such that p1 - p2 > h. For an inferiority test, specify the
lower limit (-h) for the range of practical equivalence and specify values
of p1 and p2 such that p1 - p2 > -h. This function sets the effect size
equal to p1 - p2.
}
\examples{
size.supinf.prop2(.05, .9, .35, .20, .05)

# Should return:
#      Sample size per group
# [1,]                   408


}
