% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{ERRVL}
\alias{ERRVL}
\title{Return the first argument passed (out of any number) that is not a
\code{try-error} (result of \code{\link[base]{try}} encountering an error.}
\usage{
ERRVL(...)
}
\arguments{
\item{\dots}{Expressions to be tested; usually outputs of
\code{\link[base]{try}}.}
}
\value{
The first argument that is not a \code{try-error}. Stops with an
error if all are.
}
\description{
This function is inspired by \code{\link{NVL}}, and simply returns the first
argument that is not a \code{try-error}, raising an error if all arguments
are \code{try-error}s.
}
\examples{

print(ERRVL(1,2,3)) # 1
print(ERRVL(try(solve(0)),2,3)) # 2
}
\seealso{
\code{\link[base]{try}}, \code{\link[base]{inherits}}
}
\keyword{utilities}
