% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_isd_station_data.R
\name{get_isd_station_data}
\alias{get_isd_station_data}
\title{Get met station data from the ISD dataset}
\usage{
get_isd_station_data(station_id, startyear, endyear, local_tz = TRUE)
}
\arguments{
\item{station_id}{a station identifier composed of the station's USAF and WBAN numbers, separated
by a hyphen.}

\item{startyear}{the starting year for the collected data.}

\item{endyear}{the ending year for the collected data.}

\item{local_tz}{a boolean value stating whether a correction should be made to local time from UTC+00.}
}
\description{
Obtain one or more years of meteorological data for a station from the NCEI Integrated
Surface Dataset (ISD).
}
\examples{
\dontrun{
# Obtain a listing of all stations within a bounding box and
# then isolate a single station and obtain a string with the
# \\code{usaf} and \\code{wban} identifiers.
# Pass that identifier string to the \\code{get_isd_station_data}
# function to obtain a data frame of meteorological data for
# the year 2010
stations_within_domain <-
  get_isd_stations(lower_lat = 49.000,
                   upper_lat = 49.500,
                   lower_lon = -123.500,
                   upper_lon = -123.000)

cypress_bowl_snowboard_stn <-
  select_isd_station(stn_df = stations_within_domain,
                     name = "cypress bowl snowboard")

cypress_bowl_snowboard_stn_met_data <-
  get_isd_station_data(station_id = cypress_bowl_snowboard_stn,
                       startyear = 2010,
                       endyear = 2010)
}
}

