/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import vcf.AL;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class HbdAL
implements AL {
    private final GL gl;

    public HbdAL(GL gL) {
        if (gL == null) {
            throw new NullPointerException("em==null");
        }
        this.gl = gL;
    }

    @Override
    public float al(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this.gl.marker(n).nAlleles()) {
            String string = "marker=" + n + " allele: " + n3;
            throw new IllegalArgumentException(string);
        }
        int n4 = n2 / 2;
        return this.gl.gl(n, n4, n3, n3);
    }

    @Override
    public int allele(int n, int n2) {
        int n3;
        int n4 = n2 / 2;
        int n5 = this.gl.allele1(n, n4);
        return n5 != (n3 = this.gl.allele2(n, n4)) ? -1 : n5;
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public int nHaps() {
        return 2 * this.gl.nSamples();
    }

    @Override
    public float errProb() {
        return 0.0f;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[HbdGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nHaps=");
        stringBuilder.append(this.nHaps());
        stringBuilder.append(Const.nl);
        stringBuilder.append(this.gl);
        stringBuilder.append(Const.nl);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

