% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StateSpaceForecast.R
\name{StateSpaceForecast}
\alias{StateSpaceForecast}
\title{State Space Model Forecasting}
\usage{
StateSpaceForecast(
  fit,
  addvar_list_fc = NULL,
  level_addvar_list_fc = NULL,
  self_spec_list_fc = NULL,
  forecast_period = 1
)
}
\arguments{
\item{fit}{A list containing the specifications of the State Space Model, as
returned by \code{\link{StateSpaceFit}} or \code{\link{StateSpaceEval}}.}

\item{addvar_list_fc}{A list containing the explanatory variables for each
of the dependent variables. The list should contain p (number of dependent
variables) elements. Each element of the list should be a
\code{forecast_period} x k_p matrix, with k_p being the number of explanatory
variables for the pth dependent variable. If no explanatory variables
should be added for one of the dependent variables, then set the
corresponding element to \code{NULL}.}

\item{level_addvar_list_fc}{A list containing the explanatory variables
for each of the dependent variables. The list should contain p
(number of dependent variables) elements. Each element of the list should
be a \code{forecast_period} x k_p matrix, with k_p being the number of
explanatory variables for the pth dependent variable. If no explanatory
variables should be added for one of the dependent variables, then set
the corresponding element to \code{NULL}.}

\item{self_spec_list_fc}{A list containing the specification of the self
specified component. Does not have to be specified if it does not differ
from \code{self_spec_list} as passed on to \code{StateSpaceFit()} or
\code{StateSpaceEval()}. If some system matrices are time-varying then you
should specify this argument. See \code{StateSpaceFit()} for details about the
format that must be followed for this argument.}

\item{forecast_period}{Number of time steps to forecast ahead.}
}
\value{
A list containing the forecasts and corresponding uncertainties.
In addition, it returns the components of the forecasts, as specified
by the State Space model.
}
\description{
Produces forecasts using a fitted State Space Model.
}
\examples{
# Fits a local level model for the Nile data
library(datasets)
y <- matrix(Nile)
fit <- StateSpaceFit(initial = 1, y = y / 100, local_level_ind = TRUE)

# Obtain forecasts for 10 steps ahead using the fitted model
fc <- StateSpaceForecast(fit, forecast_period = 10)

# Plot the forecasts
plot(1:10, fc$y_fc * 100, type = 'l')

}
\references{
\insertRef{durbin2012time}{statespacer}
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
