% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StateSpaceEval.R
\name{StateSpaceEval}
\alias{StateSpaceEval}
\title{State Space Model Evaluation at Specified Parameters}
\usage{
StateSpaceEval(
  param,
  y,
  H_format = NULL,
  local_level_ind = FALSE,
  slope_ind = FALSE,
  BSM_vec = NULL,
  cycle_ind = FALSE,
  addvar_list = NULL,
  level_addvar_list = NULL,
  arima_list = NULL,
  sarima_list = NULL,
  self_spec_list = NULL,
  exclude_level = NULL,
  exclude_slope = NULL,
  exclude_BSM_list = lapply(BSM_vec, FUN = function(x) 0),
  exclude_cycle_list = list(0),
  exclude_arima_list = lapply(arima_list, FUN = function(x) 0),
  exclude_sarima_list = lapply(sarima_list, FUN = function(x) 0),
  damping_factor_ind = rep(TRUE, length(exclude_cycle_list)),
  format_level = NULL,
  format_slope = NULL,
  format_BSM_list = lapply(BSM_vec, FUN = function(x) NULL),
  format_cycle_list = lapply(exclude_cycle_list, FUN = function(x) NULL),
  format_addvar = NULL,
  format_level_addvar = NULL,
  loglik_only = FALSE
)
}
\arguments{
\item{param}{Parameters used to construct the system matrices.}

\item{y}{N x p matrix containing the N observations of the p
dependent variables.}

\item{H_format}{Format of the H system matrix,
the variance - covariance matrix of the observation equation.}

\item{local_level_ind}{Boolean indicating whether a local level should
be added to the state space model.}

\item{slope_ind}{Boolean indicating whether a local level + slope should
be added to the state space model.}

\item{BSM_vec}{Vector containing the BSM seasonalities that have to be added
to the state space model.}

\item{cycle_ind}{Boolean indicating whether a cycle has to be added
to the state space model.}

\item{addvar_list}{A list containing the explanatory variables for each of
the dependent variables. The list should contain p (number of dependent
variables) elements. Each element of the list should be a N x k_p matrix,
with k_p being the number of explanatory variables for the pth
dependent variable. If no explanatory variables should be added for one
of the dependent variables, then set the corresponding element to \code{NULL}.}

\item{level_addvar_list}{A list containing the explanatory variables for
each of the dependent variables. The list should contain p (number of
dependent variables) elements. Each element of the list should be a
N x k_p matrix, with k_p being the number of explanatory variables
for the pth dependent variable. If no explanatory variables should be
added for one of the dependent variables, then set the corresponding
element to \code{NULL}.}

\item{arima_list}{Specifications of the ARIMA components, should be a list
containing vectors of length 3 with the following format: \code{c(AR, I, MA)}.
Should be a list to allow different ARIMA models for different sets of
dependent variables. Note: The AR and MA coefficients are
constrained such that the AR component is stationary, and the MA
component is invertible.
See \insertCite{ansley1986note;textual}{statespacer} for details about
the transformation used.}

\item{sarima_list}{Specifications of the SARIMA components, should be a list
containing lists that contain 4 named vectors. Vectors should be named:
"s", "ar", "i", "ma". Should be a list of lists to allow different SARIMA
models for different sets of dependent variables. Note: The AR and MA
coefficients are constrained such that the AR components are stationary,
and the MA components are invertible.
See \insertCite{ansley1986note;textual}{statespacer} for details about
the transformation used. Note: For multivariate models, the order of "s"
matters, as matrix multiplication is not commutative!}

\item{self_spec_list}{A list containing the specification of the self
specified component. See the Details section of \code{StateSpaceFit()} for
extensive details about the format that must be followed for this
argument.}

\item{exclude_level}{Vector containing the dependent variables that should
not get a local level.}

\item{exclude_slope}{Vector containing the dependent variables that should
not get a slope.}

\item{exclude_BSM_list}{List of vectors, each vector containing the
dependent variables that should not get the corresponding BSM component.}

\item{exclude_cycle_list}{The dependent variables that should not get the
corresponding cycle component. Should be a list of vectors to allow
different dependent variables to be excluded for different cycles.}

\item{exclude_arima_list}{The dependent variables that should not be
involved in the corresponding ARIMA component. Should be a list of
vectors to allow different dependent variables to be excluded for
different ARIMA components.}

\item{exclude_sarima_list}{The dependent variables that should not be
involved in the corresponding SARIMA component. Should be a list of
vectors to allow different dependent variables to be excluded for
different SARIMA components.}

\item{damping_factor_ind}{Boolean indicating whether a damping factor should
be included. Must be a vector if multiple cycles are included,
to indicate which cycles should include a damping factor.}

\item{format_level}{Format of the Q_level system matrix
the variance - covariance matrix of the level state equation.}

\item{format_slope}{Format of the Q_slope system matrix,
the variance - covariance matrix of the slope state equation.}

\item{format_BSM_list}{Format of the Q_BSM system matrix,
the variance - covariance matrix of the BSM state equation. Should be a
list to allow different formats for different seasonality periods.}

\item{format_cycle_list}{Format of the Q_cycle system matrix,
the variance - covariance matrix of the cycle state equation. Should be a
list to allow different formats for different cycles.}

\item{format_addvar}{Format of the Q_addvar system matrix, the
variance - covariance matrix of the explanatory variables state equation.}

\item{format_level_addvar}{Format of the Q_level_addvar system matrix, the
variance - covariance matrix of the explanatory variables of the level
state equation.}

\item{loglik_only}{Boolean indicating whether only the
loglikelihood should be returned.}
}
\value{
A list containing:
\itemize{
\item \code{function_call}: A list containing the input to the function.
\item \code{system_matrices}: A list containing the system matrices of
the State Space model.
\item \code{predicted}: A list containing the predicted components of
the State Space model.
\item \code{filtered}: A list containing the filtered components of
the State Space model.
\item \code{smoothed}: A list containing the smoothed components of
the State Space model.
\item \code{diagnostics}: A list containing items useful for diagnostical tests.
}

For extensive details about the object returned,
see \code{vignette("dictionary", package = "statespacer")}.
}
\description{
Evaluates the specified State Space model at the parameters
specified by the user.
}
\examples{
# Evaluates a local level model for the Nile data at given parameters
library(datasets)
y <- matrix(Nile)
eval <- StateSpaceEval(param = c(1, 1), y = y / 100, local_level_ind = TRUE)

}
\references{
\insertRef{durbin2012time}{statespacer}

\insertRef{ansley1986note}{statespacer}
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
