% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gwstates}
\alias{gwstates}
\title{Gleditsch and Ward list of independent states}
\format{Data frame
\describe{
 \item{\code{gwcode}}{Gleditsch and Ward country code.}
 \item{\code{iso3c}}{ISO 3 character country code.}
 \item{\code{country_name}}{Long form country name}
 \item{\code{start}}{Country start of independence.}
 \item{\code{end}}{Country end of independence.}
 \item{\code{microstate}}{Logical flag for whether state is a microstates with less than 250,000 population.}
}}
\source{
Gleditsch, Kristian S. and Michael D. Ward. 1999. ``Interstate System
Membership: A Revised List of the Independent States since 1816."
International Interactions 25.
}
\usage{
gwstates
}
\description{
A list of independent states and microstates from 1816 on by
  Gleditsch and Ward
}
\examples{
data(gwstates)
head(gwstates)
}
\keyword{datasets}
