% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.hclust.R
\name{graph.hclust}
\alias{graph.hclust}
\title{Hierarchical Cluster Analysis on a List of Graphs}
\usage{
graph.hclust(Graphs, k = NULL, clus_method = "complete", dist = "JS", ...)
}
\arguments{
\item{Graphs}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{k}{the number of clusters. If NULL, it won't return the computed clustering.}

\item{clus_method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of ''ward.D'', ''ward.D2'', ''single'',
''complete'', ''average'' (= UPGMA), ''mcquitty'' (= WPGMA), ''median''
(= WPGMC) or ''centroid'' (= UPGMC).}

\item{dist}{string indicating if you want to use the 'JS' (default), 'L1' or 'L2'
distances. 'JS' means Jensen-Shannon divergence.}

\item{...}{Other relevant parameters for \code{\link{graph.spectral.density}}.}
}
\value{
A list with class 'statGraph' containing the following components:
\item{\code{method:}}{ a string indicating the used method.}
\item{\code{info:}}{ a string showing details about the method.}
\item{\code{data.name:}}{ a string with the data's name(s).}
\item{\code{cluster:}}{ a vector of the same length of \code{Graphs} containing the clusterization
labels.}
\item{\code{hclust:}}{ a 'hclust' object.}
}
\description{
Given a list of graphs, \code{graph.hclust} builds a hierarchy of clusters
according to the Jensen-Shannon divergence between graphs.
}
\examples{
set.seed(1)
G <- list()
for (i in 1:5) {
  G[[i]] <- igraph::sample_gnp(50, 0.5)
}
for (i in 6:10) {
  G[[i]] <- igraph::sample_smallworld(1, 50, 8, 0.2)
}
for (i in 11:15) {
  G[[i]] <- igraph::sample_pa(50, power = 1, directed = FALSE)
}
graph.hclust(G, 3)

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{clustering}
