% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.test}
\alias{graph.test}
\title{Test for the Jensen-Shannon divergence between graphs}
\usage{
graph.test(x, y, numBoot = 1000, bandwidth = "Silverman")
}
\arguments{
\item{x}{a list of adjacency (symmetric) matrices. For unweighted graphs,
each matrix contains only 0s and 1s. For weighted graphs, each matrix
contains real values that correspond to the weights of the edges.}

\item{y}{a list of adjacency (symmetric) matrices. For unweighted graphs,
each matrix contains only 0s and 1s. For weighted graphs, each matrix
contains real values that correspond to the weights of the edges.}

\item{numBoot}{integer indicating the number of bootstrap resamplings.}

\item{bandwidth}{string indicating which criterion will be used to choose
the bandwidth for the spectral density estimation. The available criteria are
"Silverman" (default) and "Sturges".}
}
\value{
A list containing:
\item{JS}{the Jensen-Shannon divergence between 'x' and 'y'.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{graph.test} tests whether two sets of graphs were generated by the same
random graph model.
This bootstrap test is based on the Jensen-Shannon (JS) divergence between
graphs.
}
\details{
Given two lists of graphs, 'x' and 'y', 'graph.test' tests H0: "JS divergence
between 'x' and 'y' is 0" against H1: "JS divergence between 'x' and 'y' is
larger than 0".
}
\examples{
library(igraph)
x <- y <- list()
for (i in 1:20)
   x[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50, p=0.5)))
for (i in 1:20)
   y[[i]] <- as.matrix(get.adjacency(erdos.renyi.game(50, p=0.51)))

result <- graph.test(x, y, numBoot=100)
result

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. \emph{PLoS ONE}, \emph{7}, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) \emph{Density Estimation}.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. \emph{J. Am. Statist. Assoc.},
\emph{21}, 65-66.
}
\keyword{graph_comparison}
