% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_memory.R
\name{panel_memory_state}
\alias{panel_memory_state}
\title{Create a memory state space time}
\usage{
panel_memory_state(
  data = NULL,
  combined = data$config$memory$combined,
  legend = data$config$memory$legend,
  base_size = data$config$base_size,
  expand_x = data$config$expand,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  show_state_total = data$config$memory$state$total,
  show_transfer_total = data$config$memory$transfer$total
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{combined}{shows links}

\item{legend}{enable/disable legends}

\item{base_size}{base_size base font size}

\item{expand_x}{expand size for scale_x_continuous padding}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{show_state_total}{Show the percentage of selected state}

\item{show_transfer_total}{Show total transfer amount}
}
\value{
A ggplot object
}
\description{
Show memory events
}
\examples{
panel_memory_state(data = starvz_sample_lu)
}
