% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_util.R
\name{panel_gflops_computed_difference}
\alias{panel_gflops_computed_difference}
\title{Plot the total computed GFlops difference over time given two traces}
\usage{
panel_gflops_computed_difference(
  data1 = NULL,
  data2 = NULL,
  legend = FALSE,
  x_start = NULL,
  x_end = NULL,
  add_end_line = TRUE
)
}
\arguments{
\item{data1}{starvz_data with trace data}

\item{data2}{starvz_data with trace data}

\item{legend}{enable/disable plot legends}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{add_end_line}{add smaller end time vertical line}
}
\value{
A ggplot object
}
\description{
Use starvz_data Application and the GFlop columns to create a plot that shows
the total computed GFlop difference over time using geom_line. The blue color
represent the faster execution and the red the slower one.
}
\examples{
\dontrun{
panel_gflops_computed_difference(data1, data2)
}
}
