% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_project_file.R
\name{use_project_file}
\alias{use_project_file}
\alias{use_project_gitignore}
\alias{use_project_readme}
\title{Write a template file}
\usage{
use_project_file(
  name = NULL,
  filename = NULL,
  template = NULL,
  open = interactive()
)

use_project_gitignore(filename = NULL, template = NULL)

use_project_readme(filename = NULL, template = NULL)
}
\arguments{
\item{name}{Name of file to write.  Not sure of the files available to you?
Run the function without specifying a name, and all files available within the
template will print.}

\item{filename}{Optional argument to specify the name of the file to be written.
Paths/filename is relative to project base}

\item{template}{A project template. See
\href{https://www.danieldsjoberg.com/starter/articles/create_project.html}{vignette}
for details.}

\item{open}{If \code{TRUE}, opens the new file.}
}
\value{
NULL, places single template file in current working directory
}
\description{
Rather than using \code{create_project()} to start a new project folder, you
may use \code{use_project_file()} to write a single file from any project template.
The functions \code{use_project_gitignore()} and \code{use_project_readme()} are shortcuts for
\code{use_project_file("gitignore")} and \code{use_project_file("readme")}.
}
\examples{
# only run fn interactively, will place files in current working dir
if (interactive()) {
  # create gitignore file
  use_project_file("gitignore")
  use_project_gitignore()

  # create README.md file
  use_project_file("readme")
  use_project_readme()
}
}
\seealso{
\code{\link[=create_project]{create_project()}}

\href{https://www.danieldsjoberg.com/starter/articles/create_project.html}{Vignette for \code{create_project()}}
}
